/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.cache;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackgroundCache<K, V, E extends Exception> {
    private static final int TIMER_THREAD_PRIORITY = 3;
    private final String name;
    private final Class<E> exceptionClass;
    final long refreshInterval;
    private final long expirationAge;
    final Logger logger;
    final Timer timer;
    final ConcurrentMap<K, CacheEntry> map = new ConcurrentHashMap<K, CacheEntry>();

    public BackgroundCache(String name, Class<E> exceptionClass, long refreshInterval, long expirationAge, Logger logger) {
        this.name = name;
        this.exceptionClass = exceptionClass;
        this.refreshInterval = refreshInterval;
        this.expirationAge = expirationAge;
        this.logger = logger;
        this.timer = new Timer(name + "-backgroundTimer", true);
    }

    public BackgroundCache(String name, Class<E> exceptionClass, long refreshInterval, long expirationAge) {
        this(name, exceptionClass, refreshInterval, expirationAge, Logger.getLogger(BackgroundCache.class.getName()));
    }

    public String toString() {
        return this.name;
    }

    public void stop() {
        this.timer.cancel();
        this.map.clear();
    }

    public Result<V, E> get(K key, Refresher<? super K, ? extends V, ? extends E> refresher) {
        Result<Object, Object> result = this.get(key);
        if (result == null) {
            result = this.put(key, refresher);
        }
        return result;
    }

    public Result<V, E> get(K key) {
        CacheEntry entry = (CacheEntry)this.map.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getResult();
    }

    Result<V, E> runRefresher(Refresher<? super K, ? extends V, ? extends E> refresher, K key) throws IllegalStateException {
        try {
            return new Result(refresher.call(key));
        }
        catch (Exception e) {
            if (this.exceptionClass.isInstance(e)) {
                return new Result((Exception)this.exceptionClass.cast(e));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            AssertionError ae = new AssertionError((Object)"Unexpected exception type");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public Result<V, E> put(K key, Refresher<? super K, ? extends V, ? extends E> refresher) {
        Result<? extends V, ? extends E> result = this.runRefresher(refresher, key);
        this.put(key, refresher, result);
        return result;
    }

    public void put(K key, Refresher<? super K, ? extends V, ? extends E> refresher, V value) {
        this.put(key, refresher, new Result(value));
    }

    public void put(K key, Refresher<? super K, ? extends V, ? extends E> refresher, E exception) {
        this.put(key, refresher, new Result(exception));
    }

    private void put(K key, Refresher<? super K, ? extends V, ? extends E> refresher, Result<V, E> result) {
        CacheEntry entry = new CacheEntry(key, refresher, result);
        this.map.put(key, entry);
        this.timer.schedule((TimerTask)entry, new Date(System.currentTimeMillis() + this.refreshInterval), this.refreshInterval);
    }

    public int size() {
        return this.map.size();
    }

    class CacheEntry
    extends TimerTask {
        private final K key;
        private final Refresher<? super K, ? extends V, ? extends E> refresher;
        private volatile Result<V, E> result;
        private volatile long refreshed;
        private volatile boolean accessedSinceRefresh;
        private volatile long expiration;

        CacheEntry(K key, Refresher<? super K, ? extends V, ? extends E> refresher, Result<V, E> result) {
            long currentTime = System.currentTimeMillis();
            this.key = key;
            this.refresher = refresher;
            this.result = result;
            this.refreshed = currentTime;
            this.accessedSinceRefresh = true;
            this.expiration = currentTime + BackgroundCache.this.expirationAge;
        }

        Result<V, E> getResult() {
            if (!this.accessedSinceRefresh) {
                this.accessedSinceRefresh = true;
                this.expiration = this.refreshed + BackgroundCache.this.expirationAge;
            }
            return this.result;
        }

        @Override
        public void run() {
            block7: {
                Thread currentThread = Thread.currentThread();
                if (currentThread.getPriority() != 3) {
                    currentThread.setPriority(3);
                }
                if (this != BackgroundCache.this.map.get(this.key)) {
                    this.cancel();
                } else {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime >= this.expiration || currentTime < this.refreshed) {
                        BackgroundCache.this.map.remove(this.key, this);
                        this.cancel();
                    } else {
                        try {
                            this.result = BackgroundCache.this.runRefresher(this.refresher, this.key);
                            this.refreshed = currentTime;
                            this.accessedSinceRefresh = false;
                        }
                        catch (Throwable t) {
                            BackgroundCache.this.map.remove(this.key, this);
                            this.cancel();
                            if (!BackgroundCache.this.logger.isLoggable(Level.WARNING)) break block7;
                            BackgroundCache.this.logger.log(Level.WARNING, "BackgroundCache(" + BackgroundCache.this.name + ").CacheEntry(" + this.key + ").run(): Unexpected exception in background cache refresh, dropped from cache", t);
                        }
                    }
                }
            }
        }
    }

    public static class Result<V, E extends Exception> {
        private final V value;
        private final E exception;

        Result(V value) {
            this.value = value;
            this.exception = null;
        }

        Result(E exception) {
            this.exception = exception;
            this.value = null;
        }

        public V getValue() {
            return this.value;
        }

        public E getException() {
            return this.exception;
        }
    }

    public static interface Refresher<K, V, E extends Exception> {
        public V call(K var1) throws E;
    }
}

