/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.awt.image;

import com.aoindustries.io.IoUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public final class Images {
    public static int[] getRGBArray(int width, int height) {
        return new int[width * height];
    }

    public static int[] getRGBArray(Dimension size) {
        return Images.getRGBArray(size.width, size.height);
    }

    public static int[] getRGBArray(BufferedImage image) {
        return Images.getRGBArray(image.getWidth(), image.getHeight());
    }

    public static int[] getRGB(BufferedImage image) {
        int[] pixels = Images.getRGBArray(image);
        Images.getRGB(image, pixels);
        return pixels;
    }

    public static void getRGB(BufferedImage image, int[] pixels) {
        int width = image.getWidth();
        int height = image.getHeight();
        image.getRGB(0, 0, width, height, pixels, 0, width);
    }

    public static Point findImage(BufferedImage image, BufferedImage findme, double tolerance) {
        int findmeHeight;
        int imageHeight;
        int findmeWidth;
        int imageWidth = image.getWidth();
        if (imageWidth >= (findmeWidth = findme.getWidth()) && (imageHeight = image.getHeight()) >= (findmeHeight = findme.getHeight())) {
            return Images.findImage(Images.getRGB(image), imageWidth, imageHeight, Images.getRGB(findme), findmeWidth, findmeHeight, tolerance);
        }
        return null;
    }

    public static Point findImage(int[] imagePixels, int imageWidth, int imageHeight, int[] findmePixels, int findmeWidth, int findmeHeight, double tolerance) {
        int searchHeight;
        int searchWidth = imageWidth - findmeWidth;
        if (searchWidth >= 0 && (searchHeight = imageHeight - findmeHeight) >= 0) {
            double maxDeviation = 765.0 * (double)findmeWidth * (double)findmeHeight;
            long maxMismatch = (long)(tolerance * maxDeviation);
            for (int imageY = 0; imageY <= searchHeight; ++imageY) {
                block1: for (int imageX = 0; imageX <= searchWidth; ++imageX) {
                    long totalMismatch = 0L;
                    int findMeIndex = 0;
                    for (int findmeY = 0; findmeY < findmeHeight; ++findmeY) {
                        for (int findmeX = 0; findmeX < findmeWidth; ++findmeX) {
                            int findmePixel;
                            int imagePixel = imagePixels[(imageY + findmeY) * imageWidth + imageX + findmeX];
                            if (imagePixel != (findmePixel = findmePixels[findMeIndex++]) && (imagePixel & 0xFF000000) != 0 && (findmePixel & 0xFF000000) != 0 && (totalMismatch += (long)(Math.abs((imagePixel >>> 16 & 0xFF) - (findmePixel >>> 16 & 0xFF)) + Math.abs((imagePixel >>> 8 & 0xFF) - (findmePixel >>> 8 & 0xFF)) + Math.abs((imagePixel & 0xFF) - (findmePixel & 0xFF)))) > maxMismatch) continue block1;
                        }
                    }
                    return new Point(imageX, imageY);
                }
            }
        }
        return null;
    }

    public static Image getImageFromResources(Class<?> clazz, String name) throws IOException {
        return Images.getImageFromResources(clazz, name, Toolkit.getDefaultToolkit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromResources(Class<?> clazz, String name, Toolkit toolkit) throws IOException {
        byte[] imageData;
        InputStream in = clazz.getResourceAsStream(name);
        if (in == null) {
            throw new IOException("Unable to find resource: " + name);
        }
        try {
            imageData = IoUtils.readFully((InputStream)in);
        }
        finally {
            in.close();
        }
        return toolkit.createImage(imageData);
    }

    private Images() {
    }
}

