/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.awt.image;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ImageSizeCache {
    private static final Map<String, CacheEntry> sizeCache = new HashMap<String, CacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(File imageFile) throws IOException {
        CacheEntry entry;
        Object object = sizeCache;
        synchronized (object) {
            String canonicalPath = imageFile.getCanonicalPath();
            CacheEntry ce = sizeCache.get(canonicalPath);
            if (ce == null) {
                ce = new CacheEntry();
                sizeCache.put(canonicalPath, ce);
            }
            entry = ce;
        }
        object = entry;
        synchronized (object) {
            long lastModified = imageFile.lastModified();
            long length = imageFile.length();
            if (entry.size == null || lastModified != entry.lastModified || length != entry.length) {
                BufferedImage img = ImageIO.read(imageFile);
                if (img == null) {
                    throw new IOException("Unable to read image: " + imageFile);
                }
                entry.lastModified = lastModified;
                entry.length = length;
                entry.size = new Dimension(img.getWidth(), img.getHeight());
            }
            return new Dimension(entry.size);
        }
    }

    private ImageSizeCache() {
    }

    static class CacheEntry {
        long lastModified;
        long length;
        Dimension size;

        CacheEntry() {
        }
    }
}

