/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

public class MultiBorderLayout
extends BorderLayout {
    private static final long serialVersionUID = 1L;
    protected List<Component> northComponents;
    protected List<Component> westComponents;
    protected List<Component> eastComponents;
    protected List<Component> southComponents;
    protected Component center;

    public MultiBorderLayout() {
    }

    public MultiBorderLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object name) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = "Center";
            }
            if ("Center".equals(name)) {
                this.center = component;
            } else if ("North".equals(name)) {
                if (this.northComponents == null) {
                    this.northComponents = new ArrayList<Component>();
                }
                this.northComponents.add(component);
            } else if ("South".equals(name)) {
                if (this.southComponents == null) {
                    this.southComponents = new ArrayList<Component>();
                }
                this.southComponents.add(component);
            } else if ("East".equals(name)) {
                if (this.eastComponents == null) {
                    this.eastComponents = new ArrayList<Component>();
                }
                this.eastComponents.add(component);
            } else if ("West".equals(name)) {
                if (this.westComponents == null) {
                    this.westComponents = new ArrayList<Component>();
                }
                this.westComponents.add(component);
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    @Override
    @Deprecated
    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getLayoutSize(Container target, boolean minimum) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        int width = 0;
        int height = 0;
        Object object = target.getTreeLock();
        synchronized (object) {
            int c;
            Dimension D;
            Component C;
            int c2;
            int size = this.westComponents == null ? 0 : this.westComponents.size();
            for (c2 = 0; c2 < size; ++c2) {
                C = this.westComponents.get(c2);
                if (!C.isVisible()) continue;
                D = minimum ? C.getMinimumSize() : C.getPreferredSize();
                width += D.width + hgap;
                if (D.height <= height) continue;
                height = D.height;
            }
            size = this.eastComponents == null ? 0 : this.eastComponents.size();
            for (c2 = 0; c2 < size; ++c2) {
                C = this.eastComponents.get(c2);
                if (!C.isVisible()) continue;
                D = minimum ? C.getMinimumSize() : C.getPreferredSize();
                width += D.width + hgap;
                if (D.height <= height) continue;
                height = D.height;
            }
            if (this.center != null && this.center.isVisible()) {
                Dimension D2 = minimum ? this.center.getMinimumSize() : this.center.getPreferredSize();
                width += D2.width;
                if (D2.height > height) {
                    height = D2.height;
                }
            }
            size = this.northComponents == null ? 0 : this.northComponents.size();
            for (c = 0; c < size; ++c) {
                C = this.northComponents.get(c);
                if (!C.isVisible()) continue;
                D = minimum ? C.getMinimumSize() : C.getPreferredSize();
                height += D.height + vgap;
                if (D.width <= width) continue;
                width = D.width;
            }
            size = this.southComponents == null ? 0 : this.southComponents.size();
            for (c = 0; c < size; ++c) {
                C = this.southComponents.get(c);
                if (!C.isVisible()) continue;
                D = minimum ? C.getMinimumSize() : C.getPreferredSize();
                height += D.height + vgap;
                if (D.width <= width) continue;
                width = D.width;
            }
            Insets insets = target.getInsets();
            return new Dimension(insets.left + width + insets.right, insets.top + height + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        Object object = target.getTreeLock();
        synchronized (object) {
            Component C;
            int c;
            Insets insets = target.getInsets();
            Dimension D = target.getSize();
            int top = insets.top;
            int bottom = D.height - insets.bottom;
            int left = insets.left;
            int right = D.width - insets.right;
            int size = this.northComponents == null ? 0 : this.northComponents.size();
            for (c = 0; c < size; ++c) {
                C = this.northComponents.get(c);
                if (!C.isVisible()) continue;
                D = C.getSize();
                C.setSize(right - left, D.height);
                D = C.getPreferredSize();
                C.setBounds(left, top, right - left, D.height);
                top += D.height + vgap;
            }
            int n = c = this.southComponents == null ? -1 : this.southComponents.size() - 1;
            while (c >= 0) {
                C = this.southComponents.get(c);
                if (C.isVisible()) {
                    D = C.getSize();
                    C.setSize(right - left, D.height);
                    D = C.getPreferredSize();
                    C.setBounds(left, bottom - D.height, right - left, D.height);
                    bottom -= D.height + vgap;
                }
                --c;
            }
            size = this.westComponents == null ? 0 : this.westComponents.size();
            for (c = 0; c < size; ++c) {
                C = this.westComponents.get(c);
                if (!C.isVisible()) continue;
                D = C.getSize();
                C.setSize(D.width, bottom - top);
                D = C.getPreferredSize();
                C.setBounds(left, top, D.width, bottom - top);
                left += D.width + hgap;
            }
            int n2 = c = this.eastComponents == null ? -1 : this.eastComponents.size() - 1;
            while (c >= 0) {
                C = this.eastComponents.get(c);
                if (C.isVisible()) {
                    D = C.getSize();
                    C.setSize(D.width, bottom - top);
                    D = C.getPreferredSize();
                    C.setBounds(right - D.width, top, D.width, bottom - top);
                    right -= D.width + hgap;
                }
                --c;
            }
            if (this.center != null && this.center.isVisible()) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.getLayoutSize(target, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.getLayoutSize(target, false);
    }

    public static boolean remove(Object O, List<Component> V) {
        int size = V.size();
        for (int c = 0; c < size; ++c) {
            if (V.get(c) != O) continue;
            V.remove(c);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.center) {
                this.center = null;
            } else if (!(this.northComponents != null && MultiBorderLayout.remove(component, this.northComponents) || this.westComponents != null && MultiBorderLayout.remove(component, this.westComponents) || this.eastComponents != null && MultiBorderLayout.remove(component, this.eastComponents) || this.southComponents == null)) {
                MultiBorderLayout.remove(component, this.southComponents);
            }
        }
    }
}

