/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.util.BufferManager;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletResponse;

public class TrimFilterWriter
extends PrintWriter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final ServletResponse response;
    boolean inTextArea = false;
    boolean inPre = false;
    private boolean atLineStart = true;
    private int readCharMatchCount = 0;
    private int preReadCharMatchCount = 0;
    private char[] outputBuffer = BufferManager.getChars();
    private String isTrimEnabledCacheContentType;
    private boolean isTrimEnabledCacheResult;
    static final char[] textarea = new char[]{'<', 't', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    static final char[] TEXTAREA = new char[]{'<', 'T', 'E', 'X', 'T', 'A', 'R', 'E', 'A'};
    static final char[] textarea_close = new char[]{'<', '/', 't', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    static final char[] TEXTAREA_CLOSE = new char[]{'<', '/', 'T', 'E', 'X', 'T', 'A', 'R', 'E', 'A'};
    static final char[] pre = new char[]{'<', 'p', 'r', 'e'};
    static final char[] PRE = new char[]{'<', 'P', 'R', 'E'};
    static final char[] pre_close = new char[]{'<', '/', 'p', 'r', 'e'};
    static final char[] PRE_CLOSE = new char[]{'<', '/', 'P', 'R', 'E'};

    public TrimFilterWriter(Writer out, ServletResponse response) {
        super(out);
        this.response = response;
    }

    private boolean isTrimEnabled() {
        String contentType = this.response.getContentType();
        if (contentType != this.isTrimEnabledCacheContentType) {
            this.isTrimEnabledCacheResult = contentType == null || contentType.equals("application/xhtml+xml") || contentType.startsWith("application/xhtml+xml;") || contentType.equals("text/html") || contentType.startsWith("text/html;") || contentType.equals("application/xml") || contentType.startsWith("application/xml;") || contentType.equals("text/xml") || contentType.startsWith("text/xml;");
            this.isTrimEnabledCacheContentType = contentType;
        }
        return this.isTrimEnabledCacheResult;
    }

    @Override
    public void close() {
        if (this.outputBuffer != null) {
            BufferManager.release((char[])this.outputBuffer, (boolean)false);
            this.outputBuffer = null;
        }
        super.close();
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.inTextArea = false;
        this.inPre = false;
        this.atLineStart = true;
    }

    private boolean processChar(char c) {
        if (this.inTextArea) {
            if (c == textarea_close[this.readCharMatchCount] || c == TEXTAREA_CLOSE[this.readCharMatchCount]) {
                ++this.readCharMatchCount;
                if (this.readCharMatchCount >= textarea_close.length) {
                    this.inTextArea = false;
                    this.readCharMatchCount = 0;
                }
            } else {
                this.readCharMatchCount = 0;
            }
            return true;
        }
        if (this.inPre) {
            if (c == pre_close[this.preReadCharMatchCount] || c == PRE_CLOSE[this.preReadCharMatchCount]) {
                ++this.preReadCharMatchCount;
                if (this.preReadCharMatchCount >= pre_close.length) {
                    this.inPre = false;
                    this.preReadCharMatchCount = 0;
                }
            } else {
                this.preReadCharMatchCount = 0;
            }
            return true;
        }
        if (c == '\r') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            return !this.atLineStart;
        }
        if (c == '\n') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            if (!this.atLineStart) {
                this.atLineStart = true;
                return true;
            }
            return false;
        }
        if (c == ' ' || c == '\t') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            return !this.atLineStart;
        }
        this.atLineStart = false;
        if (c == textarea[this.readCharMatchCount] || c == TEXTAREA[this.readCharMatchCount]) {
            ++this.readCharMatchCount;
            if (this.readCharMatchCount >= textarea.length) {
                this.inTextArea = true;
                this.readCharMatchCount = 0;
            }
        } else {
            this.readCharMatchCount = 0;
        }
        if (c == pre[this.preReadCharMatchCount] || c == PRE[this.preReadCharMatchCount]) {
            ++this.preReadCharMatchCount;
            if (this.preReadCharMatchCount >= pre.length) {
                this.inPre = true;
                this.preReadCharMatchCount = 0;
            }
        } else {
            this.preReadCharMatchCount = 0;
        }
        return true;
    }

    @Override
    public void write(int c) {
        if (!this.isTrimEnabled() || this.processChar((char)c)) {
            super.write(c);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.isTrimEnabled()) {
            char[] buff = this.outputBuffer;
            int buffUsed = 0;
            while (len > 0) {
                int blockLen = len <= 4096 ? len : 4096;
                int blockEnd = off + blockLen;
                for (int index = off; index < blockEnd; ++index) {
                    char c = buf[index];
                    if (!this.processChar(c)) continue;
                    buff[buffUsed++] = c;
                    if (buffUsed < 4096) continue;
                    assert (buffUsed == 4096);
                    super.write(buff, 0, buffUsed);
                    buffUsed = 0;
                }
                off += blockLen;
                len -= blockLen;
            }
            if (buffUsed > 0) {
                super.write(buff, 0, buffUsed);
            }
        } else {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(char[] buf) {
        if (this.isTrimEnabled()) {
            this.write(buf, 0, buf.length);
        } else {
            super.write(buf);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        if (this.isTrimEnabled()) {
            char[] buff = this.outputBuffer;
            int buffUsed = 0;
            while (len > 0) {
                int blockLen = len <= 4096 ? len : 4096;
                int blockEnd = off + blockLen;
                for (int index = off; index < blockEnd; ++index) {
                    char c = s.charAt(index);
                    if (!this.processChar(c)) continue;
                    buff[buffUsed++] = c;
                    if (buffUsed < 4096) continue;
                    assert (buffUsed == 4096);
                    super.write(buff, 0, buffUsed);
                    buffUsed = 0;
                }
                off += blockLen;
                len -= blockLen;
            }
            if (buffUsed > 0) {
                super.write(buff, 0, buffUsed);
            }
        } else {
            super.write(s, off, len);
        }
    }

    @Override
    public void print(boolean b) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.print(b);
    }

    @Override
    public void print(char c) {
        if (!this.isTrimEnabled() || this.processChar(c)) {
            super.print(c);
        }
    }

    @Override
    public void print(int i) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.print(i);
    }

    @Override
    public void print(long l) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.print(l);
    }

    @Override
    public void print(float f) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.print(f);
    }

    @Override
    public void print(double d) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.print(d);
    }

    @Override
    public void println() {
        if (this.isTrimEnabled()) {
            this.write(lineSeparator);
        } else {
            super.println();
        }
    }

    @Override
    public void println(boolean b) {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.println(b);
    }

    @Override
    public void println(char x) {
        if (this.isTrimEnabled()) {
            if (this.processChar(x)) {
                super.print(x);
            }
            this.write(lineSeparator);
        } else {
            super.println(x);
        }
    }

    @Override
    public void println(int i) {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.println(i);
    }

    @Override
    public void println(long l) {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.println(l);
    }

    @Override
    public void println(float f) {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.println(f);
    }

    @Override
    public void println(double d) {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.println(d);
    }

    @Override
    public void println(char[] x) {
        if (this.isTrimEnabled()) {
            this.print(x);
            this.write(lineSeparator);
        } else {
            super.println(x);
        }
    }

    @Override
    public void println(String x) {
        if (this.isTrimEnabled()) {
            this.print(x);
            this.write(lineSeparator);
        } else {
            super.println(x);
        }
    }

    @Override
    public void println(Object x) {
        if (this.isTrimEnabled()) {
            this.print(x);
            this.write(lineSeparator);
        } else {
            super.println(x);
        }
    }

    @Override
    public TrimFilterWriter format(String format, Object ... args) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.format(format, args);
        return this;
    }

    @Override
    public TrimFilterWriter format(Locale l, String format, Object ... args) {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        super.format(l, format, args);
        return this;
    }
}

