/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.servlet.filter.TrimFilterWriter;
import com.aoindustries.util.BufferManager;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

public class TrimFilterOutputStream
extends ServletOutputStream {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final ServletOutputStream wrapped;
    private final ServletResponse response;
    boolean inTextArea = false;
    boolean inPre = false;
    private boolean atLineStart = true;
    private int readCharMatchCount = 0;
    private int preReadCharMatchCount = 0;
    private byte[] outputBuffer = BufferManager.getBytes();
    private String isTrimEnabledCacheContentType;
    private boolean isTrimEnabledCacheResult;

    public TrimFilterOutputStream(ServletOutputStream wrapped, ServletResponse response) {
        this.wrapped = wrapped;
        this.response = response;
    }

    private boolean isTrimEnabled() {
        String contentType = this.response.getContentType();
        if (contentType != this.isTrimEnabledCacheContentType) {
            this.isTrimEnabledCacheResult = contentType == null || contentType.equals("application/xhtml+xml") || contentType.startsWith("application/xhtml+xml;") || contentType.equals("text/html") || contentType.startsWith("text/html;") || contentType.equals("application/xml") || contentType.startsWith("application/xml;") || contentType.equals("text/xml") || contentType.startsWith("text/xml;");
            this.isTrimEnabledCacheContentType = contentType;
        }
        return this.isTrimEnabledCacheResult;
    }

    public void flush() throws IOException {
        this.wrapped.flush();
    }

    public void close() throws IOException {
        if (this.outputBuffer != null) {
            BufferManager.release((byte[])this.outputBuffer, (boolean)false);
            this.outputBuffer = null;
        }
        this.wrapped.close();
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.inTextArea = false;
        this.inPre = false;
        this.atLineStart = true;
    }

    private boolean processChar(char c) {
        if (this.inTextArea) {
            if (c == TrimFilterWriter.textarea_close[this.readCharMatchCount] || c == TrimFilterWriter.TEXTAREA_CLOSE[this.readCharMatchCount]) {
                ++this.readCharMatchCount;
                if (this.readCharMatchCount >= TrimFilterWriter.textarea_close.length) {
                    this.inTextArea = false;
                    this.readCharMatchCount = 0;
                }
            } else {
                this.readCharMatchCount = 0;
            }
            return true;
        }
        if (this.inPre) {
            if (c == TrimFilterWriter.pre_close[this.preReadCharMatchCount] || c == TrimFilterWriter.PRE_CLOSE[this.preReadCharMatchCount]) {
                ++this.preReadCharMatchCount;
                if (this.preReadCharMatchCount >= TrimFilterWriter.pre_close.length) {
                    this.inPre = false;
                    this.preReadCharMatchCount = 0;
                }
            } else {
                this.preReadCharMatchCount = 0;
            }
            return true;
        }
        if (c == '\r') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            return !this.atLineStart;
        }
        if (c == '\n') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            if (!this.atLineStart) {
                this.atLineStart = true;
                return true;
            }
            return false;
        }
        if (c == ' ' || c == '\t') {
            this.readCharMatchCount = 0;
            this.preReadCharMatchCount = 0;
            return !this.atLineStart;
        }
        this.atLineStart = false;
        if (c == TrimFilterWriter.textarea[this.readCharMatchCount] || c == TrimFilterWriter.TEXTAREA[this.readCharMatchCount]) {
            ++this.readCharMatchCount;
            if (this.readCharMatchCount >= TrimFilterWriter.textarea.length) {
                this.inTextArea = true;
                this.readCharMatchCount = 0;
            }
        } else {
            this.readCharMatchCount = 0;
        }
        if (c == TrimFilterWriter.pre[this.preReadCharMatchCount] || c == TrimFilterWriter.PRE[this.preReadCharMatchCount]) {
            ++this.preReadCharMatchCount;
            if (this.preReadCharMatchCount >= TrimFilterWriter.pre.length) {
                this.inPre = true;
                this.preReadCharMatchCount = 0;
            }
        } else {
            this.preReadCharMatchCount = 0;
        }
        return true;
    }

    public void write(int b) throws IOException {
        if (!this.isTrimEnabled() || this.processChar((char)b)) {
            this.wrapped.write(b);
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.isTrimEnabled()) {
            byte[] buff = this.outputBuffer;
            int buffUsed = 0;
            while (len > 0) {
                int blockLen = len <= 4096 ? len : 4096;
                int blockEnd = off + blockLen;
                for (int index = off; index < blockEnd; ++index) {
                    byte b = buf[index];
                    if (!this.processChar((char)b)) continue;
                    buff[buffUsed++] = b;
                    if (buffUsed < 4096) continue;
                    assert (buffUsed == 4096);
                    this.wrapped.write(buff, 0, buffUsed);
                    buffUsed = 0;
                }
                off += blockLen;
                len -= blockLen;
            }
            if (buffUsed > 0) {
                this.wrapped.write(buff, 0, buffUsed);
            }
        } else {
            this.wrapped.write(buf, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.isTrimEnabled()) {
            this.write(b, 0, b.length);
        } else {
            this.wrapped.write(b);
        }
    }

    public void print(boolean b) throws IOException {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.print(b);
    }

    public void print(char c) throws IOException {
        if (!this.isTrimEnabled() || this.processChar(c)) {
            this.wrapped.print(c);
        }
    }

    public void print(double d) throws IOException {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.print(d);
    }

    public void print(float f) throws IOException {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.print(f);
    }

    public void print(int i) throws IOException {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.print(i);
    }

    public void print(long l) throws IOException {
        this.atLineStart = false;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.print(l);
    }

    public void print(String s) throws IOException {
        if (this.isTrimEnabled()) {
            int blockLen;
            byte[] buff = this.outputBuffer;
            int off = 0;
            int buffUsed = 0;
            for (int len = s.length(); len > 0; len -= blockLen) {
                blockLen = len <= 4096 ? len : 4096;
                int blockEnd = off + blockLen;
                for (int index = off; index < blockEnd; ++index) {
                    char c = s.charAt(index);
                    if (!this.processChar(c)) continue;
                    buff[buffUsed++] = (byte)c;
                    if (buffUsed < 4096) continue;
                    assert (buffUsed == 4096);
                    this.wrapped.write(buff, 0, buffUsed);
                    buffUsed = 0;
                }
                off += blockLen;
            }
            if (buffUsed > 0) {
                this.wrapped.write(buff, 0, buffUsed);
            }
        } else {
            this.wrapped.print(s);
        }
    }

    public void println() throws IOException {
        if (this.isTrimEnabled()) {
            this.print(lineSeparator);
        } else {
            this.wrapped.println();
        }
    }

    public void println(boolean b) throws IOException {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.println(b);
    }

    public void println(char c) throws IOException {
        if (this.isTrimEnabled()) {
            if (this.processChar(c)) {
                this.wrapped.print(c);
            }
            this.print(lineSeparator);
        } else {
            this.wrapped.println(c);
        }
    }

    public void println(double d) throws IOException {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.println(d);
    }

    public void println(float f) throws IOException {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.println(f);
    }

    public void println(int i) throws IOException {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.println(i);
    }

    public void println(long l) throws IOException {
        this.atLineStart = true;
        this.readCharMatchCount = 0;
        this.preReadCharMatchCount = 0;
        this.wrapped.println(l);
    }

    public void println(String s) throws IOException {
        if (this.isTrimEnabled()) {
            this.print(s);
            this.print(lineSeparator);
        } else {
            this.wrapped.println(s);
        }
    }
}

