/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.servlet.filter.TrimFilterResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class TrimFilter
implements Filter {
    private static final String REQUEST_ATTRIBUTE_KEY = TrimFilter.class.getName() + ".filter_applied";
    private boolean enabled;

    public void init(FilterConfig config) {
        String enabledParam = config.getServletContext().getInitParameter("com.aoindustries.servlet.filter.TrimFilter.enabled");
        if (enabledParam == null || (enabledParam = enabledParam.trim()).length() == 0) {
            enabledParam = "true";
        }
        this.enabled = Boolean.parseBoolean(enabledParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled && request.getAttribute(REQUEST_ATTRIBUTE_KEY) == null && response instanceof HttpServletResponse) {
            request.setAttribute(REQUEST_ATTRIBUTE_KEY, (Object)Boolean.TRUE);
            try {
                chain.doFilter(request, (ServletResponse)new TrimFilterResponse((HttpServletResponse)response));
            }
            finally {
                request.removeAttribute(REQUEST_ATTRIBUTE_KEY);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.enabled = false;
    }
}

