/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.io.TempFileList;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TempFileContext
implements Filter {
    private static final Logger logger = Logger.getLogger(TempFileContext.class.getName());
    private static final String PREFIX = TempFileContext.class.getSimpleName();
    private static final String REQUEST_ATTRIBUTE_NAME = TempFileContext.class.getName() + ".tempFileList";
    private static final TempFileWarningLock tempFileWarningLock = new TempFileWarningLock();
    private static boolean tempFileWarned = false;

    public static TempFileList getTempFileList(ServletRequest request) {
        return (TempFileList)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T wrapTempFileList(T original, TempFileList tempFileList, Wrapper<T> wrapper) {
        if (tempFileList != null) {
            return wrapper.call(original, tempFileList);
        }
        TempFileWarningLock tempFileWarningLock = TempFileContext.tempFileWarningLock;
        synchronized (tempFileWarningLock) {
            if (!tempFileWarned) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "TempFileContext not initialized: refusing to automatically create temp files for large buffers.  Additional heap space may be used for large requests.  Please add the " + TempFileContext.class.getName() + " filter to your web.xml file.", new Throwable("Stack Trace"));
                }
                tempFileWarned = true;
            }
        }
        return original;
    }

    public static <T> T wrapTempFileList(T original, ServletRequest request, Wrapper<T> wrapper) {
        return TempFileContext.wrapTempFileList(original, TempFileContext.getTempFileList(request), wrapper);
    }

    public void init(FilterConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TempFileList list = (TempFileList)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (list == null) {
            list = new TempFileList(PREFIX);
            try {
                request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)list);
                chain.doFilter(request, response);
            }
            finally {
                request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
                list.delete();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static class TempFileWarningLock {
        private TempFileWarningLock() {
        }
    }

    public static interface Wrapper<T> {
        public T call(T var1, TempFileList var2);
    }
}

