/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.net.ServletRequestParameters;
import com.aoindustries.servlet.http.ServletUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class StripInvalidXmlCharactersFilter
implements Filter {
    private static boolean isValidCharacter(int ch) {
        return ch >= 32 && ch <= 55295 || ch == 9 || ch == 10 || ch == 13 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValid(String s) {
        int len = s.length();
        int pos = 0;
        while (pos < len) {
            int ch;
            int ch1;
            if (Character.isHighSurrogate((char)(ch1 = s.charAt(pos++)))) {
                char ch2;
                if (pos >= len) return false;
                if (!Character.isLowSurrogate(ch2 = s.charAt(pos++))) return false;
                ch = Character.toCodePoint((char)ch1, ch2);
            } else {
                ch = ch1;
            }
            if (StripInvalidXmlCharactersFilter.isValidCharacter(ch)) continue;
            return false;
        }
        return true;
    }

    private static String filter(String s) {
        int len = s.length();
        StringBuilder filtered = new StringBuilder(len);
        int pos = 0;
        while (pos < len) {
            char ch1;
            if (Character.isHighSurrogate(ch1 = s.charAt(pos++))) {
                char ch2;
                if (pos >= len || !Character.isLowSurrogate(ch2 = s.charAt(pos++)) || !StripInvalidXmlCharactersFilter.isValidCharacter(Character.toCodePoint(ch1, ch2))) continue;
                filtered.append(ch1).append(ch2);
                continue;
            }
            if (!StripInvalidXmlCharactersFilter.isValidCharacter(ch1)) continue;
            filtered.append(ch1);
        }
        assert (filtered.length() <= len);
        return filtered.length() != len ? filtered.toString() : s;
    }

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Map paramMap = new ServletRequestParameters(request).getParameterMap();
            boolean isValid = true;
            block0: for (Map.Entry entry : paramMap.entrySet()) {
                for (String paramValue : (List)entry.getValue()) {
                    if (StripInvalidXmlCharactersFilter.isValid(paramValue)) continue;
                    isValid = false;
                    continue block0;
                }
            }
            if (!isValid) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String responseEncoding = response.getCharacterEncoding();
                if ("GET".equals(httpRequest.getMethod())) {
                    StringBuilder url = new StringBuilder();
                    ServletUtil.getAbsoluteURL((HttpServletRequest)httpRequest, (String)ServletUtil.getContextRequestUri((HttpServletRequest)httpRequest), (Appendable)url);
                    boolean didOne = false;
                    for (Map.Entry entry : paramMap.entrySet()) {
                        String name = (String)entry.getKey();
                        for (String value : (List)entry.getValue()) {
                            if (didOne) {
                                url.append('&');
                            } else {
                                url.append('?');
                                didOne = true;
                            }
                            url.append(URLEncoder.encode(name, responseEncoding)).append('=').append(URLEncoder.encode(StripInvalidXmlCharactersFilter.filter(value), responseEncoding));
                        }
                    }
                    ServletUtil.sendRedirect((HttpServletResponse)httpResponse, (String)url.toString(), (int)301);
                } else {
                    final LinkedHashMap filteredMap = new LinkedHashMap(paramMap.size() * 4 / 3 + 1);
                    for (Map.Entry entry : paramMap.entrySet()) {
                        List values = (List)entry.getValue();
                        ArrayList<String> filteredValues = new ArrayList<String>(values.size());
                        for (String value : values) {
                            filteredValues.add(StripInvalidXmlCharactersFilter.filter(value));
                        }
                        filteredMap.put(entry.getKey(), filteredValues);
                    }
                    chain.doFilter((ServletRequest)new HttpServletRequestWrapper(httpRequest){

                        public String getParameter(String name) {
                            List values = (List)filteredMap.get(name);
                            if (values == null || values.isEmpty()) {
                                return null;
                            }
                            return (String)values.get(0);
                        }

                        public Map<String, String[]> getParameterMap() {
                            LinkedHashMap<String, String[]> newMap = new LinkedHashMap<String, String[]>(filteredMap.size() * 4 / 3 + 1);
                            for (Map.Entry entry : filteredMap.entrySet()) {
                                List values = (List)entry.getValue();
                                newMap.put((String)entry.getKey(), values.toArray(new String[values.size()]));
                            }
                            return newMap;
                        }

                        public Enumeration<String> getParameterNames() {
                            return Collections.enumeration(filteredMap.keySet());
                        }

                        public String[] getParameterValues(String name) {
                            List values = (List)filteredMap.get(name);
                            if (values == null) {
                                return null;
                            }
                            return values.toArray(new String[values.size()]);
                        }
                    }, (ServletResponse)httpResponse);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

