/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.util.WildcardPatternMatcher;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotFoundFilter
implements Filter {
    private WildcardPatternMatcher patterns;

    public void init(FilterConfig config) {
        String param = config.getInitParameter("patterns");
        this.patterns = param == null ? WildcardPatternMatcher.getMatchAll() : WildcardPatternMatcher.getInstance((String)param);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String message = "404 Not Found";
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (this.patterns.isMatch(httpRequest.getServletPath())) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(404, "404 Not Found");
            } else {
                chain.doFilter(request, response);
            }
        } else {
            throw new ServletException("404 Not Found");
        }
    }

    public void destroy() {
    }
}

