/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.util.StringUtility;
import com.aoindustries.util.WrappedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

public class NoSessionFilter
implements Filter {
    private static final String FILTER_APPLIED_KEY = NoSessionFilter.class.getName() + ".filterApplied";
    public static final String COOKIE_URL_PARAM_PREFIX = "cookie:";
    public static final int MAXIMUM_COOKIES = 20;
    private final SortedSet<String> cookieNames = new TreeSet<String>();

    private String addCookieValues(HttpServletRequest request, Map<String, Cookie> newCookies, String url, String encoding) {
        String anchor;
        int poundPos = url.lastIndexOf(35);
        if (poundPos == -1) {
            anchor = null;
        } else {
            anchor = url.substring(poundPos);
            url = url.substring(0, poundPos);
        }
        int questionPos = url.lastIndexOf(63);
        String lowerPath = (questionPos == -1 ? url : url.substring(0, questionPos)).toLowerCase(Locale.ROOT);
        if (!(lowerPath.endsWith(".css") || lowerPath.endsWith(".gif") || lowerPath.endsWith(".ico") || lowerPath.endsWith(".jpeg") || lowerPath.endsWith(".jpg") || lowerPath.endsWith(".js") || lowerPath.endsWith(".png") || lowerPath.endsWith(".txt") || lowerPath.endsWith(".zip"))) {
            try {
                Cookie[] oldCookies = null;
                boolean oldCookiesSet = false;
                StringBuilder urlSB = new StringBuilder(url);
                boolean hasParam = questionPos != -1;
                for (String cookieName : this.cookieNames) {
                    if (newCookies.containsKey(cookieName)) {
                        Cookie newCookie = newCookies.get(cookieName);
                        if (newCookie == null) continue;
                        if (hasParam) {
                            urlSB.append('&');
                        } else {
                            urlSB.append('?');
                            hasParam = true;
                        }
                        urlSB.append(URLEncoder.encode(COOKIE_URL_PARAM_PREFIX + cookieName, encoding)).append('=').append(URLEncoder.encode(newCookie.getValue(), encoding));
                        continue;
                    }
                    String paramName = COOKIE_URL_PARAM_PREFIX + cookieName;
                    String[] values = request.getParameterValues(paramName);
                    if (values == null || values.length <= 0) continue;
                    boolean found = false;
                    if (!oldCookiesSet) {
                        oldCookies = request.getCookies();
                        oldCookiesSet = true;
                    }
                    if (oldCookies != null) {
                        for (Cookie oldCookie : oldCookies) {
                            if (!oldCookie.getName().equals(cookieName)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    if (hasParam) {
                        urlSB.append('&');
                    } else {
                        urlSB.append('?');
                        hasParam = true;
                    }
                    urlSB.append(URLEncoder.encode(paramName, encoding)).append('=').append(URLEncoder.encode(values[values.length - 1], encoding));
                }
                url = urlSB.toString();
            }
            catch (UnsupportedEncodingException err) {
                throw new WrappedException((Throwable)err);
            }
        }
        if (anchor != null) {
            url = url + anchor;
        }
        return url;
    }

    public void init(FilterConfig config) {
        this.cookieNames.clear();
        String cookieNamesInitParam = config.getInitParameter("cookieNames");
        if (cookieNamesInitParam != null) {
            this.cookieNames.addAll(StringUtility.splitStringCommaSpace((String)cookieNamesInitParam));
        }
        if (this.cookieNames.size() > 20) {
            throw new IllegalArgumentException("cookieNames.size()>20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(FILTER_APPLIED_KEY) == null) {
            try {
                request.setAttribute(FILTER_APPLIED_KEY, (Object)Boolean.TRUE);
                if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                    final HttpServletRequest originalRequest = (HttpServletRequest)request;
                    HttpServletResponse originalResponse = (HttpServletResponse)response;
                    final HashMap newCookies = new HashMap(this.cookieNames.size() * 4 / 3 + 1);
                    chain.doFilter((ServletRequest)new HttpServletRequestWrapper(originalRequest){

                        public HttpSession getSession() {
                            throw new RuntimeException("Sessions are disabled by NoSessionFilter");
                        }

                        public HttpSession getSession(boolean create) {
                            if (create) {
                                throw new RuntimeException("Sessions are disabled by NoSessionFilter");
                            }
                            return null;
                        }

                        public String getParameter(String name) {
                            if (name.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) {
                                return null;
                            }
                            return super.getParameter(name);
                        }

                        public Map<String, String[]> getParameterMap() {
                            Map completeMap = super.getParameterMap();
                            boolean needsFilter = false;
                            for (String paramName : completeMap.keySet()) {
                                if (!paramName.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) continue;
                                needsFilter = true;
                                break;
                            }
                            if (!needsFilter) {
                                return completeMap;
                            }
                            LinkedHashMap filteredMap = new LinkedHashMap(completeMap.size() * 4 / 3);
                            for (Map.Entry entry : completeMap.entrySet()) {
                                String paramName = (String)entry.getKey();
                                if (paramName.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) continue;
                                filteredMap.put(paramName, entry.getValue());
                            }
                            return Collections.unmodifiableMap(filteredMap);
                        }

                        public Enumeration<String> getParameterNames() {
                            final Enumeration completeNames = super.getParameterNames();
                            return new Enumeration<String>(){
                                private String nextName = null;

                                @Override
                                public boolean hasMoreElements() {
                                    if (this.nextName != null) {
                                        return true;
                                    }
                                    while (completeNames.hasMoreElements()) {
                                        String name = (String)completeNames.nextElement();
                                        if (name.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) continue;
                                        this.nextName = name;
                                        return true;
                                    }
                                    return false;
                                }

                                @Override
                                public String nextElement() {
                                    String name = this.nextName;
                                    if (name != null) {
                                        this.nextName = null;
                                        return name;
                                    }
                                    while ((name = (String)completeNames.nextElement()).startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) {
                                    }
                                    return name;
                                }
                            };
                        }

                        public String[] getParameterValues(String name) {
                            if (name.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX)) {
                                return null;
                            }
                            return super.getParameterValues(name);
                        }

                        public Cookie[] getCookies() {
                            Cookie[] headerCookies = originalRequest.getCookies();
                            Enumeration parameterNames = originalRequest.getParameterNames();
                            if (headerCookies == null && !parameterNames.hasMoreElements()) {
                                return null;
                            }
                            LinkedHashMap<String, Cookie> allCookies = new LinkedHashMap<String, Cookie>(NoSessionFilter.this.cookieNames.size() * 4 / 3 + 1);
                            if (headerCookies != null) {
                                for (Cookie cookie : headerCookies) {
                                    String cookieName = cookie.getName();
                                    if (!NoSessionFilter.this.cookieNames.contains(cookieName)) continue;
                                    allCookies.put(cookieName, cookie);
                                }
                            }
                            while (parameterNames.hasMoreElements()) {
                                String cookieName;
                                String paramName = (String)parameterNames.nextElement();
                                if (!paramName.startsWith(NoSessionFilter.COOKIE_URL_PARAM_PREFIX) || allCookies.containsKey(cookieName = paramName.substring(NoSessionFilter.COOKIE_URL_PARAM_PREFIX.length())) || !NoSessionFilter.this.cookieNames.contains(cookieName)) continue;
                                String value = originalRequest.getParameter(paramName);
                                assert (value != null);
                                Cookie newCookie = new Cookie(cookieName, value);
                                newCookie.setPath(originalRequest.getContextPath() + "/");
                                allCookies.put(cookieName, newCookie);
                            }
                            return allCookies.values().toArray(new Cookie[allCookies.size()]);
                        }
                    }, (ServletResponse)new HttpServletResponseWrapper(originalResponse){

                        @Deprecated
                        public String encodeRedirectUrl(String url) {
                            return this.encodeRedirectURL(url);
                        }

                        public String encodeRedirectURL(String url) {
                            String remaining;
                            String protocol;
                            if (url.length() > 0 && url.charAt(0) == '#') {
                                return url;
                            }
                            if (url.length() > 7 && (protocol = url.substring(0, 7)).equalsIgnoreCase("http://")) {
                                remaining = url.substring(7);
                            } else if (url.length() > 8 && (protocol = url.substring(0, 8)).equalsIgnoreCase("https://")) {
                                remaining = url.substring(8);
                            } else {
                                if (url.startsWith("javascript:")) {
                                    return url;
                                }
                                if (url.startsWith("mailto:")) {
                                    return url;
                                }
                                if (url.startsWith("telnet:")) {
                                    return url;
                                }
                                if (url.startsWith("tel:")) {
                                    return url;
                                }
                                if (url.startsWith("cid:")) {
                                    return url;
                                }
                                return NoSessionFilter.this.addCookieValues(originalRequest, newCookies, url, this.getCharacterEncoding());
                            }
                            int slashPos = remaining.indexOf(47);
                            if (slashPos == -1) {
                                return NoSessionFilter.this.addCookieValues(originalRequest, newCookies, url, this.getCharacterEncoding());
                            }
                            String hostPort = remaining.substring(0, slashPos);
                            int colonPos = hostPort.indexOf(58);
                            String host = colonPos == -1 ? hostPort : hostPort.substring(0, colonPos);
                            String encoded = host.equalsIgnoreCase(originalRequest.getServerName()) ? protocol + hostPort + NoSessionFilter.this.addCookieValues(originalRequest, newCookies, remaining.substring(slashPos), this.getCharacterEncoding()) : url;
                            return encoded;
                        }

                        @Deprecated
                        public String encodeUrl(String url) {
                            return this.encodeURL(url);
                        }

                        public String encodeURL(String url) {
                            String remaining;
                            String protocol;
                            if (url.length() > 0 && url.charAt(0) == '#') {
                                return url;
                            }
                            if (url.length() > 7 && (protocol = url.substring(0, 7)).equalsIgnoreCase("http://")) {
                                remaining = url.substring(7);
                            } else if (url.length() > 8 && (protocol = url.substring(0, 8)).equalsIgnoreCase("https://")) {
                                remaining = url.substring(8);
                            } else {
                                if (url.startsWith("javascript:")) {
                                    return url;
                                }
                                if (url.startsWith("tel:")) {
                                    return url;
                                }
                                if (url.startsWith("cid:")) {
                                    return url;
                                }
                                return NoSessionFilter.this.addCookieValues(originalRequest, newCookies, url, this.getCharacterEncoding());
                            }
                            int slashPos = remaining.indexOf(47);
                            if (slashPos == -1) {
                                return NoSessionFilter.this.addCookieValues(originalRequest, newCookies, url, this.getCharacterEncoding());
                            }
                            String hostPort = remaining.substring(0, slashPos);
                            int colonPos = hostPort.indexOf(58);
                            String host = colonPos == -1 ? hostPort : hostPort.substring(0, colonPos);
                            String encoded = host.equalsIgnoreCase(originalRequest.getServerName()) ? protocol + hostPort + NoSessionFilter.this.addCookieValues(originalRequest, newCookies, remaining.substring(slashPos), this.getCharacterEncoding()) : url;
                            return encoded;
                        }

                        public void addCookie(Cookie newCookie) {
                            String cookieName = newCookie.getName();
                            if (!NoSessionFilter.this.cookieNames.contains(cookieName)) {
                                throw new IllegalArgumentException("Unexpected cookie name, add to cookieNames init parameter: " + cookieName);
                            }
                            super.addCookie(newCookie);
                            if (newCookie.getMaxAge() == 0) {
                                newCookies.put(cookieName, null);
                            } else {
                                boolean found = false;
                                Cookie[] oldCookies = originalRequest.getCookies();
                                if (oldCookies != null) {
                                    for (Cookie oldCookie : oldCookies) {
                                        if (!oldCookie.getName().equals(cookieName)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) {
                                    newCookies.put(cookieName, newCookie);
                                }
                            }
                        }
                    });
                }
                chain.doFilter(request, response);
            }
            finally {
                request.removeAttribute(FILTER_APPLIED_KEY);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.cookieNames.clear();
    }
}

