/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.net.ServletRequestParameters;
import com.aoindustries.net.UrlUtils;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.util.StringUtility;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.i18n.ThreadLocale;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class LocaleFilter
implements Filter {
    private static final boolean DEBUG = false;
    private static final String DEFAULT_PARAM_NAME = "hl";
    private static final String ENABLED_LOCALES_REQUEST_ATTRIBUTE_KEY = LocaleFilter.class.getName() + ".enabledLocales";
    private ServletContext servletContext;

    private String addLocale(Locale locale, String url, String encodedParamName, String encoding) {
        String anchor;
        String beforeAnchor;
        int poundPos = url.lastIndexOf(35);
        if (poundPos == -1) {
            beforeAnchor = url;
            anchor = null;
        } else {
            anchor = url.substring(poundPos);
            beforeAnchor = url.substring(0, poundPos);
        }
        if (this.isLocalizedPath(beforeAnchor)) {
            int questionPos = beforeAnchor.lastIndexOf(63);
            if (questionPos == -1 || !beforeAnchor.startsWith("?" + encodedParamName + "=", questionPos) && beforeAnchor.indexOf("&" + encodedParamName + "=", questionPos + 1) == -1) {
                try {
                    beforeAnchor = beforeAnchor + (questionPos == -1 ? (char)'?' : '&') + encodedParamName + '=' + URLEncoder.encode(this.toLocaleString(locale), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new WrappedException((Throwable)e);
                }
            }
            return anchor != null ? beforeAnchor + anchor : beforeAnchor;
        }
        return url;
    }

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    public static Map<String, Locale> getEnabledLocales(ServletRequest request) {
        Map enabledLocales = (Map)request.getAttribute(ENABLED_LOCALES_REQUEST_ATTRIBUTE_KEY);
        if (enabledLocales == null) {
            throw new IllegalStateException("Not in request filtered by LocaleFilter, unable to get enabled locales.");
        }
        return enabledLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ENABLED_LOCALES_REQUEST_ATTRIBUTE_KEY) == null && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            Map<String, Locale> supportedLocales = this.getSupportedLocales(request);
            request.setAttribute(ENABLED_LOCALES_REQUEST_ATTRIBUTE_KEY, supportedLocales);
            try {
                boolean rewriteUrls;
                Locale responseLocale;
                final HttpServletRequest httpRequest = (HttpServletRequest)request;
                final HttpServletResponse httpResponse = (HttpServletResponse)response;
                String requestEncoding = ServletUtil.getRequestEncoding((ServletRequest)request);
                String responseEncoding = response.getCharacterEncoding();
                String requestUri = ServletUtil.getContextRequestUri((HttpServletRequest)httpRequest);
                boolean isLocalized = this.isLocalizedPath(requestUri);
                String paramName = this.getParamName();
                final String encodedParamName = URLEncoder.encode(paramName, responseEncoding);
                String paramValue = httpRequest.getParameter(paramName);
                if (paramValue != null && httpRequest.getMethod().equals("GET") && (!isLocalized || supportedLocales.size() < 2)) {
                    StringBuilder url = new StringBuilder();
                    url.append(UrlUtils.decodeUrlPath((String)requestUri, (String)requestEncoding));
                    boolean didOne = false;
                    for (Map.Entry entry : new ServletRequestParameters(request).getParameterMap().entrySet()) {
                        String name = (String)entry.getKey();
                        if (paramName.equals(name)) continue;
                        for (String value : (List)entry.getValue()) {
                            if (didOne) {
                                url.append('&');
                            } else {
                                url.append('?');
                                didOne = true;
                            }
                            url.append(URLEncoder.encode(name, responseEncoding)).append('=').append(URLEncoder.encode(value, responseEncoding));
                        }
                    }
                    ServletUtil.sendRedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (String)url.toString(), (int)301);
                    return;
                }
                if (!isLocalized) {
                    chain.doFilter(request, response);
                    return;
                }
                if (supportedLocales.isEmpty()) {
                    chain.doFilter(request, response);
                    return;
                }
                if (supportedLocales.size() < 2) {
                    assert (supportedLocales.size() == 1);
                    responseLocale = supportedLocales.values().iterator().next();
                    rewriteUrls = false;
                } else {
                    MatchedLocale matched;
                    assert (supportedLocales.size() >= 2);
                    Locale locale = null;
                    if (paramValue != null && (locale = supportedLocales.get(paramValue)) == null && (matched = this.getBestMatch(supportedLocales, paramValue)) != null) {
                        locale = matched.locale;
                    }
                    if (locale == null) {
                        locale = this.getBestLocale(httpRequest, supportedLocales);
                        assert (locale != null);
                    }
                    String localeString = this.toLocaleString(locale);
                    if (httpRequest.getMethod().equals("GET") && !localeString.equals(paramValue)) {
                        StringBuilder url = new StringBuilder();
                        url.append(UrlUtils.decodeUrlPath((String)requestUri, (String)requestEncoding));
                        boolean didOne = false;
                        for (Map.Entry entry : new ServletRequestParameters(request).getParameterMap().entrySet()) {
                            String name = (String)entry.getKey();
                            if (paramName.equals(name)) continue;
                            for (String value : (List)entry.getValue()) {
                                if (didOne) {
                                    url.append('&');
                                } else {
                                    url.append('?');
                                    didOne = true;
                                }
                                url.append(URLEncoder.encode(name, responseEncoding)).append('=').append(URLEncoder.encode(value, responseEncoding));
                            }
                        }
                        if (didOne) {
                            url.append('&');
                        } else {
                            url.append('?');
                        }
                        url.append(encodedParamName).append('=').append(URLEncoder.encode(localeString, responseEncoding));
                        ServletUtil.sendRedirect((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (String)url.toString(), (int)301);
                        return;
                    }
                    responseLocale = locale;
                    rewriteUrls = true;
                }
                httpResponse.setLocale(responseLocale);
                httpRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", (Object)responseLocale);
                Locale oldThreadLocale = ThreadLocale.get();
                try {
                    ThreadLocale.set((Locale)responseLocale);
                    if (rewriteUrls) {
                        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)new HttpServletResponseWrapper(httpResponse){

                            @Deprecated
                            public String encodeRedirectUrl(String url) {
                                return this.encodeRedirectURL(url);
                            }

                            public String encodeRedirectURL(String url) {
                                String remaining;
                                String protocol;
                                if (url.length() > 0 && url.charAt(0) == '#') {
                                    return url;
                                }
                                if (url.length() > 7 && (protocol = url.substring(0, 7)).equalsIgnoreCase("http://")) {
                                    remaining = url.substring(7);
                                } else if (url.length() > 8 && (protocol = url.substring(0, 8)).equalsIgnoreCase("https://")) {
                                    remaining = url.substring(8);
                                } else {
                                    if (url.startsWith("javascript:")) {
                                        return httpResponse.encodeRedirectURL(url);
                                    }
                                    if (url.startsWith("mailto:")) {
                                        return httpResponse.encodeRedirectURL(url);
                                    }
                                    if (url.startsWith("telnet:")) {
                                        return httpResponse.encodeRedirectURL(url);
                                    }
                                    if (url.startsWith("tel:")) {
                                        return httpResponse.encodeRedirectURL(url);
                                    }
                                    if (url.startsWith("cid:")) {
                                        return httpResponse.encodeRedirectURL(url);
                                    }
                                    String newUrl = LocaleFilter.this.addLocale(httpResponse.getLocale(), url, encodedParamName, httpResponse.getCharacterEncoding());
                                    return httpResponse.encodeRedirectURL(newUrl);
                                }
                                int slashPos = remaining.indexOf(47);
                                if (slashPos == -1) {
                                    String newUrl = LocaleFilter.this.addLocale(httpResponse.getLocale(), url, encodedParamName, httpResponse.getCharacterEncoding());
                                    return httpResponse.encodeRedirectURL(newUrl);
                                }
                                String hostPort = remaining.substring(0, slashPos);
                                int colonPos = hostPort.indexOf(58);
                                String host = colonPos == -1 ? hostPort : hostPort.substring(0, colonPos);
                                String encoded = host.equalsIgnoreCase(httpRequest.getServerName()) ? protocol + hostPort + LocaleFilter.this.addLocale(httpResponse.getLocale(), remaining.substring(slashPos), encodedParamName, httpResponse.getCharacterEncoding()) : url;
                                return httpResponse.encodeRedirectURL(encoded);
                            }

                            @Deprecated
                            public String encodeUrl(String url) {
                                return this.encodeURL(url);
                            }

                            public String encodeURL(String url) {
                                String remaining;
                                String protocol;
                                if (url.length() > 0 && url.charAt(0) == '#') {
                                    return url;
                                }
                                if (url.length() > 7 && (protocol = url.substring(0, 7)).equalsIgnoreCase("http://")) {
                                    remaining = url.substring(7);
                                } else if (url.length() > 8 && (protocol = url.substring(0, 8)).equalsIgnoreCase("https://")) {
                                    remaining = url.substring(8);
                                } else {
                                    if (url.startsWith("javascript:")) {
                                        return httpResponse.encodeURL(url);
                                    }
                                    if (url.startsWith("mailto:")) {
                                        return httpResponse.encodeURL(url);
                                    }
                                    if (url.startsWith("telnet:")) {
                                        return httpResponse.encodeURL(url);
                                    }
                                    if (url.startsWith("tel:")) {
                                        return httpResponse.encodeURL(url);
                                    }
                                    if (url.startsWith("cid:")) {
                                        return httpResponse.encodeURL(url);
                                    }
                                    String newUrl = LocaleFilter.this.addLocale(httpResponse.getLocale(), url, encodedParamName, httpResponse.getCharacterEncoding());
                                    return httpResponse.encodeURL(newUrl);
                                }
                                int slashPos = remaining.indexOf(47);
                                if (slashPos == -1) {
                                    String newUrl = LocaleFilter.this.addLocale(httpResponse.getLocale(), url, encodedParamName, httpResponse.getCharacterEncoding());
                                    return httpResponse.encodeURL(newUrl);
                                }
                                String hostPort = remaining.substring(0, slashPos);
                                int colonPos = hostPort.indexOf(58);
                                String host = colonPos == -1 ? hostPort : hostPort.substring(0, colonPos);
                                String encoded = host.equalsIgnoreCase(httpRequest.getServerName()) ? protocol + hostPort + LocaleFilter.this.addLocale(httpResponse.getLocale(), remaining.substring(slashPos), encodedParamName, httpResponse.getCharacterEncoding()) : url;
                                return httpResponse.encodeURL(encoded);
                            }
                        });
                    }
                    chain.doFilter(request, response);
                }
                finally {
                    ThreadLocale.set((Locale)oldThreadLocale);
                }
            }
            finally {
                request.removeAttribute(ENABLED_LOCALES_REQUEST_ATTRIBUTE_KEY);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected boolean isLocalizedPath(String url) {
        int questionPos = url.lastIndexOf(63);
        String lowerPath = (questionPos == -1 ? url : url.substring(0, questionPos)).toLowerCase(Locale.ROOT);
        return !lowerPath.endsWith(".css") && !lowerPath.endsWith(".exe") && !lowerPath.endsWith(".gif") && !lowerPath.endsWith(".ico") && !lowerPath.endsWith(".jpeg") && !lowerPath.endsWith(".jpg") && !lowerPath.endsWith(".js") && !lowerPath.endsWith(".png") && !lowerPath.endsWith(".txt") && !lowerPath.endsWith(".zip");
    }

    protected String toLocaleString(Locale locale) {
        String language = locale.getLanguage();
        if (language.isEmpty()) {
            return "";
        }
        String country = locale.getCountry();
        if (country.isEmpty()) {
            return language;
        }
        String variant = locale.getVariant();
        if (variant.isEmpty()) {
            return language + '-' + country;
        }
        return language + '-' + country + '-' + variant;
    }

    protected Locale getBestLocale(HttpServletRequest request, Map<String, Locale> supportedLocales) throws ServletException {
        Enumeration acceptLanguages = request.getHeaders("accept-language");
        if (acceptLanguages == null) {
            return this.getDefaultLocale((ServletRequest)request, supportedLocales);
        }
        Locale bestExact = null;
        float bestExactQ = Float.NaN;
        Locale bestApprox = null;
        float bestApproxQ = Float.NaN;
        while (acceptLanguages.hasMoreElements()) {
            for (String pair : StringUtility.splitString((String)((String)acceptLanguages.nextElement()), (char)',')) {
                MatchedLocale match;
                float q;
                String acceptLanguage;
                int semiPos = pair.indexOf(59);
                if (semiPos == -1) {
                    acceptLanguage = pair.trim();
                    q = 1.0f;
                } else {
                    acceptLanguage = pair.substring(0, semiPos).trim();
                    try {
                        q = Float.parseFloat(pair.substring(semiPos + 1).trim());
                    }
                    catch (NumberFormatException e) {
                        q = 0.0f;
                    }
                }
                if (!(q > 0.0f) || !Float.isNaN(bestExactQ) && !(q > bestExactQ) || !Float.isNaN(bestApproxQ) && !(q > bestApproxQ) || (match = this.getBestMatch(supportedLocales, acceptLanguage)) == null) continue;
                if (match.exact) {
                    if (!Float.isNaN(bestExactQ) && !(q > bestExactQ)) continue;
                    bestExact = match.locale;
                    bestExactQ = q;
                    continue;
                }
                if (!Float.isNaN(bestApproxQ) && !(q > bestApproxQ)) continue;
                bestApprox = match.locale;
                bestApproxQ = q;
            }
        }
        Locale selected = bestExact != null ? bestExact : (bestApprox != null ? bestApprox : this.getDefaultLocale((ServletRequest)request, supportedLocales));
        return selected;
    }

    protected MatchedLocale getBestMatch(Map<String, Locale> supportedLocales, String acceptLanguage) {
        String variant;
        String country;
        String language;
        int pos1 = acceptLanguage.indexOf(45);
        if (pos1 == -1) {
            language = acceptLanguage;
            country = "";
            variant = "";
        } else {
            language = acceptLanguage.substring(0, pos1);
            int pos2 = acceptLanguage.indexOf(45, pos1 + 1);
            if (pos2 == -1) {
                country = acceptLanguage.substring(pos1 + 1);
                variant = "";
            } else {
                country = acceptLanguage.substring(pos1 + 1, pos2);
                variant = acceptLanguage.substring(pos2 + 1);
            }
        }
        if (!language.isEmpty()) {
            Locale match;
            language = language.toLowerCase(Locale.ROOT);
            if (!country.isEmpty()) {
                Locale match2;
                country = country.toUpperCase(Locale.ROOT);
                if (!variant.isEmpty() && (match2 = supportedLocales.get(this.toLocaleString(new Locale(language, country, variant)))) != null) {
                    return new MatchedLocale(match2, true);
                }
                match = supportedLocales.get(this.toLocaleString(new Locale(language, country)));
                if (match != null) {
                    return new MatchedLocale(match, variant.isEmpty());
                }
            }
            if ((match = supportedLocales.get(this.toLocaleString(new Locale(language)))) != null) {
                return new MatchedLocale(match, country.isEmpty() && variant.isEmpty());
            }
        }
        return null;
    }

    protected String getParamName() {
        return DEFAULT_PARAM_NAME;
    }

    protected abstract Map<String, Locale> getSupportedLocales(ServletRequest var1) throws ServletException;

    protected abstract Locale getDefaultLocale(ServletRequest var1, Map<String, Locale> var2) throws ServletException;

    protected static class MatchedLocale {
        private final Locale locale;
        private final boolean exact;

        protected MatchedLocale(Locale locale, boolean exact) {
            this.locale = locale;
            this.exact = exact;
        }
    }
}

