/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.net.UrlUtils;
import com.aoindustries.servlet.ServletContextCache;
import com.aoindustries.servlet.http.Dispatcher;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.util.WildcardPatternMatcher;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HideJspExtensionFilter
implements Filter {
    private static final String FILTER_APPLIED_KEY = HideJspExtensionFilter.class.getName() + ".filterApplied";
    private static final String[] EXTENSIONS = new String[]{".jspx", ".jsp"};
    private static final String[] INDEXES = new String[EXTENSIONS.length];
    private static final String[] SLASH_INDEXES = new String[EXTENSIONS.length];
    private ServletContext servletContext;
    private WildcardPatternMatcher noRewritePatterns;

    public void init(FilterConfig config) {
        ServletContext configContext;
        this.servletContext = configContext = config.getServletContext();
        String param = config.getInitParameter("noRewritePatterns");
        this.noRewritePatterns = param == null ? WildcardPatternMatcher.getMatchNone() : WildcardPatternMatcher.getInstance((String)param);
    }

    private static boolean isFolder(String path) {
        return path.isEmpty() || path.endsWith("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(FILTER_APPLIED_KEY) == null) {
            try {
                request.setAttribute(FILTER_APPLIED_KEY, (Object)Boolean.TRUE);
                if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                    boolean requestRewrite;
                    HttpServletRequest httpRequest = (HttpServletRequest)request;
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    String responseEncoding = response.getCharacterEncoding();
                    ServletContextCache servletContextCache = ServletContextCache.getCache((ServletContext)this.servletContext);
                    String servletPath = httpRequest.getServletPath();
                    boolean bl = requestRewrite = !this.noRewritePatterns.isMatch(servletPath);
                    if (requestRewrite && "GET".equals(httpRequest.getMethod())) {
                        int i;
                        for (i = 0; i < EXTENSIONS.length; ++i) {
                            String slashIndex = SLASH_INDEXES[i];
                            if (!servletPath.endsWith(slashIndex) || !httpRequest.getRequestURI().endsWith(slashIndex)) continue;
                            String queryString = httpRequest.getQueryString();
                            String path = servletPath.substring(0, servletPath.length() - INDEXES[i].length());
                            path = UrlUtils.encodeUrlPath((String)path, (String)responseEncoding);
                            if (queryString != null) {
                                path = path + '?' + queryString;
                            }
                            path = httpResponse.encodeRedirectURL(path);
                            String location = ServletUtil.getAbsoluteURL((HttpServletRequest)httpRequest, (String)path);
                            ServletUtil.sendRedirect((HttpServletResponse)httpResponse, (String)location, (int)301);
                            return;
                        }
                        for (i = 0; i < EXTENSIONS.length; ++i) {
                            String extension = EXTENSIONS[i];
                            if (!servletPath.endsWith(extension) || servletPath.endsWith(SLASH_INDEXES[i])) continue;
                            String queryString = httpRequest.getQueryString();
                            String path = servletPath.substring(0, servletPath.length() - extension.length());
                            if (HideJspExtensionFilter.isFolder(path)) continue;
                            path = UrlUtils.encodeUrlPath((String)path, (String)responseEncoding);
                            if (queryString != null) {
                                path = path + '?' + queryString;
                            }
                            path = httpResponse.encodeRedirectURL(path);
                            String location = ServletUtil.getAbsoluteURL((HttpServletRequest)httpRequest, (String)path);
                            ServletUtil.sendRedirect((HttpServletResponse)httpResponse, (String)location, (int)301);
                            return;
                        }
                    }
                    HttpServletResponseWrapper rewritingResponse = new HttpServletResponseWrapper(httpResponse){

                        private String encode(String url) {
                            int anchorPos;
                            int urlLen = url.length();
                            int questionPos = url.indexOf(63);
                            int pathEnd = questionPos != -1 ? questionPos : ((anchorPos = url.lastIndexOf(35)) != -1 ? anchorPos : urlLen);
                            String path = url.substring(0, pathEnd);
                            if (!HideJspExtensionFilter.this.noRewritePatterns.isMatch(path)) {
                                for (int i = 0; i < EXTENSIONS.length; ++i) {
                                    if (!path.endsWith(SLASH_INDEXES[i])) continue;
                                    String shortenedPath = path.substring(0, path.length() - INDEXES[i].length());
                                    if (pathEnd == urlLen) {
                                        return shortenedPath;
                                    }
                                    return shortenedPath + url.substring(pathEnd);
                                }
                                for (String extension : EXTENSIONS) {
                                    String shortenedPath;
                                    if (!path.endsWith(extension) || HideJspExtensionFilter.isFolder(shortenedPath = path.substring(0, path.length() - extension.length()))) continue;
                                    if (pathEnd == urlLen) {
                                        return shortenedPath;
                                    }
                                    return shortenedPath + url.substring(pathEnd);
                                }
                            }
                            return url;
                        }

                        @Deprecated
                        public String encodeUrl(String url) {
                            return this.encode(url);
                        }

                        public String encodeURL(String url) {
                            return this.encode(url);
                        }

                        @Deprecated
                        public String encodeRedirectUrl(String url) {
                            return this.encode(url);
                        }

                        public String encodeRedirectURL(String url) {
                            return this.encode(url);
                        }
                    };
                    if (requestRewrite && !HideJspExtensionFilter.isFolder(servletPath)) {
                        for (int i = 0; i < EXTENSIONS.length; ++i) {
                            URL resourceUrl;
                            String resourcePath = servletPath + EXTENSIONS[i];
                            if (resourcePath.endsWith(SLASH_INDEXES[i])) continue;
                            try {
                                resourceUrl = servletContextCache.getResource(resourcePath);
                            }
                            catch (MalformedURLException e) {
                                resourceUrl = null;
                            }
                            if (resourceUrl == null) continue;
                            Dispatcher.forward((ServletContext)this.servletContext, (String)resourcePath, (HttpServletRequest)httpRequest, (HttpServletResponse)rewritingResponse);
                            return;
                        }
                    }
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)rewritingResponse);
                }
                chain.doFilter(request, response);
            }
            finally {
                request.removeAttribute(FILTER_APPLIED_KEY);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.servletContext = null;
    }

    static {
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            String index;
            String extension = EXTENSIONS[i];
            HideJspExtensionFilter.INDEXES[i] = index = "index" + extension;
            HideJspExtensionFilter.SLASH_INDEXES[i] = "/" + index;
        }
    }
}

