/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FunctionContext
implements Filter {
    private static final String INIT_ERROR_MESSAGE = "Function context not initialized.  Please install FunctionContext filter to web.xml";
    static final ThreadLocal<ServletContext> servletContextTL = new ThreadLocal();
    static final ThreadLocal<HttpServletRequest> requestTL = new ThreadLocal();
    static final ThreadLocal<HttpServletResponse> responseTL = new ThreadLocal();
    private ServletContext filterServletContext;

    public static ServletContext getServletContext() {
        ServletContext servletContext = servletContextTL.get();
        if (servletContext == null) {
            throw new IllegalStateException(INIT_ERROR_MESSAGE);
        }
        return servletContext;
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = requestTL.get();
        if (request == null) {
            throw new IllegalStateException(INIT_ERROR_MESSAGE);
        }
        return request;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = responseTL.get();
        if (response == null) {
            throw new IllegalStateException(INIT_ERROR_MESSAGE);
        }
        return response;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterServletContext = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            ServletContext newServletContext = this.filterServletContext;
            HttpServletRequest newRequest = (HttpServletRequest)request;
            HttpServletResponse newResponse = (HttpServletResponse)response;
            ServletContext oldServletContext = servletContextTL.get();
            HttpServletRequest oldRequest = requestTL.get();
            HttpServletResponse oldResponse = responseTL.get();
            try {
                if (newServletContext != oldServletContext) {
                    servletContextTL.set(newServletContext);
                }
                if (newRequest != oldRequest) {
                    requestTL.set(newRequest);
                }
                if (newResponse != oldResponse) {
                    responseTL.set(newResponse);
                }
                chain.doFilter(request, response);
            }
            finally {
                if (newServletContext != oldServletContext) {
                    servletContextTL.set(oldServletContext);
                }
                if (newRequest != oldRequest) {
                    requestTL.set(oldRequest);
                }
                if (newResponse != oldResponse) {
                    responseTL.set(oldResponse);
                }
            }
        } else {
            throw new ServletException("Not using HttpServletRequest and HttpServletResponse");
        }
    }

    public void destroy() {
        this.filterServletContext = null;
    }
}

