/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CountConcurrencyFilter
implements Filter {
    private static final String REQUEST_ATTRIBUTE_NAME = CountConcurrencyFilter.class.getName() + ".concurrency";
    private final AtomicInteger concurrency = new AtomicInteger();

    public static Integer getConcurrency(ServletRequest request) {
        return (Integer)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
    }

    public void init(FilterConfig config) {
        this.concurrency.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) == null) {
            int newConcurrency = this.concurrency.incrementAndGet();
            assert (newConcurrency >= 1);
            try {
                request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)newConcurrency);
                this.onConcurrencySet(request, newConcurrency);
                chain.doFilter(request, response);
            }
            finally {
                this.onConcurrencyRemove(request);
                request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
                this.concurrency.getAndDecrement();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void onConcurrencySet(ServletRequest request, int newConcurrency) {
    }

    protected void onConcurrencyRemove(ServletRequest request) {
    }

    public void destroy() {
    }
}

