/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.servlet.filter;

import com.aoindustries.util.WildcardPatternMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AddResponseHeaderFilter
implements Filter {
    private static final String PATTERNS_PARAM_NAME = "patterns";
    private static final String REGEX_PARAM_NAME = "regex";
    private static final String REGEX_PARAM_PREFIX = "regex.";
    private WildcardPatternMatcher patterns;
    private List<Pattern> regexs;
    private Map<String, String> headers;

    public void init(FilterConfig config) {
        String paramName;
        String patternsParam = config.getInitParameter(PATTERNS_PARAM_NAME);
        this.patterns = patternsParam == null ? WildcardPatternMatcher.getMatchAll() : WildcardPatternMatcher.getInstance((String)patternsParam);
        TreeMap<Integer, Pattern> regexsByNum = new TreeMap<Integer, Pattern>();
        Enumeration paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            Integer number;
            paramName = (String)paramNames.nextElement();
            if (REGEX_PARAM_NAME.equals(paramName)) {
                number = 0;
            } else {
                if (!paramName.startsWith(REGEX_PARAM_PREFIX)) continue;
                number = Integer.valueOf(paramName.substring(REGEX_PARAM_PREFIX.length()));
            }
            if (regexsByNum.put(number, Pattern.compile(config.getInitParameter(paramName))) == null) continue;
            throw new IllegalArgumentException("Duplicate regex parameter number: " + paramName);
        }
        if (regexsByNum.isEmpty()) {
            this.regexs = Collections.emptyList();
        }
        this.regexs = regexsByNum.size() == 1 ? Collections.singletonList(regexsByNum.values().iterator().next()) : new ArrayList(regexsByNum.values());
        LinkedHashMap<String, String> foundHeaders = new LinkedHashMap<String, String>();
        paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            paramName = (String)paramNames.nextElement();
            if (!(PATTERNS_PARAM_NAME.equals(paramName) || REGEX_PARAM_NAME.equals(paramName) || paramName.startsWith(REGEX_PARAM_PREFIX) || foundHeaders.put(paramName, config.getInitParameter(paramName)) == null)) {
                throw new AssertionError((Object)("Duplicate init parameter: " + paramName));
            }
        }
        if (foundHeaders.isEmpty()) {
            this.headers = Collections.emptyMap();
        } else if (foundHeaders.size() == 1) {
            Map.Entry header = foundHeaders.entrySet().iterator().next();
            this.headers = Collections.singletonMap(header.getKey(), header.getValue());
        } else {
            this.headers = foundHeaders;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.headers.isEmpty() && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String servletPath = httpRequest.getServletPath();
            boolean matched = this.patterns.isMatch(servletPath);
            if (!matched) {
                for (Pattern regex : this.regexs) {
                    if (!regex.matcher(servletPath).matches()) continue;
                    matched = true;
                    break;
                }
            }
            if (matched) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    httpResponse.addHeader(entry.getKey(), entry.getValue());
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

