/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.TempFile;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.io.buffer.TempFileResult;
import com.aoindustries.nio.charset.Charsets;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.ClosedChannelException;

public class TempFileWriter
extends BufferWriter {
    private long length = 0L;
    private boolean isClosed = false;
    private final TempFile tempFile;
    private Writer fileWriter;
    private BufferResult result;

    public TempFileWriter(TempFile tempFile) throws IOException {
        this.tempFile = tempFile;
        this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.getFile()), Charsets.UTF_16BE));
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.write(c);
        ++this.length;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.write(cbuf);
        this.length += (long)cbuf.length;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.write(cbuf, off, len);
        this.length += (long)len;
    }

    @Override
    public void write(String str) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.write(str);
        this.length += (long)str.length();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.write(str, off, len);
        this.length += (long)len;
    }

    @Override
    public TempFileWriter append(CharSequence csq) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.append(csq);
        this.length += (long)csq.length();
        return this;
    }

    @Override
    public TempFileWriter append(CharSequence csq, int start, int end) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.append(csq, start, end);
        this.length += (long)(end - start);
        return this;
    }

    @Override
    public TempFileWriter append(char c) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.fileWriter.append(c);
        ++this.length;
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.fileWriter = null;
        }
        this.isClosed = true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return "TempFileWriter(tempFile=\"" + this.tempFile.toString() + "\", length=" + this.length + ")";
    }

    @Override
    public BufferResult getResult() throws IllegalStateException {
        if (!this.isClosed) {
            throw new IllegalStateException();
        }
        if (this.result == null) {
            this.result = this.length == 0L ? EmptyResult.getInstance() : new TempFileResult(this.tempFile, 0L, this.length);
        }
        return this.result;
    }
}

