/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.Encoder;
import com.aoindustries.io.EncoderWriter;
import com.aoindustries.io.IoUtils;
import com.aoindustries.io.TempFile;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.WrappedException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileResult
implements BufferResult {
    private static final Logger logger = Logger.getLogger(TempFileResult.class.getName());
    private final TempFile tempFile;
    private final long start;
    private final long end;
    private String toStringCache;

    protected TempFileResult(TempFile tempFile, long start, long end) {
        this.tempFile = tempFile;
        this.start = start;
        this.end = end;
    }

    public long getLength() {
        return this.end - this.start;
    }

    public boolean isFastToString() {
        return this.toStringCache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.toStringCache == null) {
            try {
                long length;
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Creating String from temp file - benefits of buffering negated.", new Throwable("Stack Trace"));
                }
                if ((length = this.end - this.start) > Integer.MAX_VALUE) {
                    throw new RuntimeException("Buffer too large to convert to String: length=" + length);
                }
                StringBuilder sb = new StringBuilder((int)length);
                RandomAccessFile raf = new RandomAccessFile(this.tempFile.getFile(), "r");
                try {
                    byte[] bytes = BufferManager.getBytes();
                    try {
                        int blockSize;
                        long index;
                        raf.seek(index << 1);
                        for (index = this.start; index < this.end; index += (long)(blockSize >> 1)) {
                            long blockSizeLong = this.end - index << 1;
                            int n = blockSize = blockSizeLong > 4096L ? 4096 : (int)blockSizeLong;
                            assert ((blockSize & 1) == 0) : "Must be an even number for UTF-16 conversion";
                            raf.readFully(bytes, 0, blockSize);
                            for (int bpos = 0; bpos < blockSize; bpos += 2) {
                                sb.append(IoUtils.bufferToChar((byte[])bytes, (int)bpos));
                            }
                        }
                    }
                    finally {
                        BufferManager.release((byte[])bytes, (boolean)false);
                    }
                }
                finally {
                    raf.close();
                }
                assert ((long)sb.length() == length) : "sb.length()!=length: " + sb.length() + "!=" + length;
                this.toStringCache = sb.toString();
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }
        return this.toStringCache;
    }

    public void writeTo(Writer out) throws IOException {
        this.writeToImpl(out, this.start, this.end);
    }

    public void writeTo(Writer out, long off, long len) throws IOException {
        if (this.start + off + len > this.end) {
            throw new IndexOutOfBoundsException();
        }
        this.writeToImpl(out, this.start + off, this.start + off + len);
    }

    public void writeTo(Encoder encoder, Writer out) throws IOException {
        this.writeTo((Writer)(encoder != null ? new EncoderWriter(encoder, out) : out));
    }

    public void writeTo(Encoder encoder, Writer out, long off, long len) throws IOException {
        this.writeTo((Writer)(encoder != null ? new EncoderWriter(encoder, out) : out), off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToImpl(Writer out, long writeStart, long writeEnd) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.tempFile.getFile(), "r");
        try {
            byte[] bytes = BufferManager.getBytes();
            try {
                char[] chars = BufferManager.getChars();
                try {
                    int blockSize;
                    long index;
                    raf.seek(index << 1);
                    for (index = writeStart; index < writeEnd; index += (long)(blockSize >> 1)) {
                        long blockSizeLong = writeEnd - index << 1;
                        int n = blockSize = blockSizeLong > 4096L ? 4096 : (int)blockSizeLong;
                        assert ((blockSize & 1) == 0) : "Must be an even number for UTF-16 conversion";
                        raf.readFully(bytes, 0, blockSize);
                        int bpos = 0;
                        int cpos = 0;
                        while (bpos < blockSize) {
                            chars[cpos] = IoUtils.bufferToChar((byte[])bytes, (int)bpos);
                            bpos += 2;
                            ++cpos;
                        }
                        out.write(chars, 0, blockSize >> 1);
                    }
                }
                finally {
                    BufferManager.release((char[])chars, (boolean)false);
                }
            }
            finally {
                BufferManager.release((byte[])bytes, (boolean)false);
            }
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferResult trim() throws IOException {
        long newEnd;
        long newStart;
        RandomAccessFile raf = new RandomAccessFile(this.tempFile.getFile(), "r");
        try {
            char ch;
            raf.seek(newStart << 1);
            for (newStart = this.start; newStart < this.end && Character.isWhitespace(ch = raf.readChar()); ++newStart) {
            }
            for (newEnd = this.end; newEnd > newStart; --newEnd) {
                raf.seek(newEnd - 1L << 1);
                ch = raf.readChar();
                if (Character.isWhitespace(ch)) continue;
                break;
            }
        }
        finally {
            raf.close();
        }
        if (this.start == newStart && this.end == newEnd) {
            return this;
        }
        if (newStart == newEnd) {
            return EmptyResult.getInstance();
        }
        return new TempFileResult(this.tempFile, newStart, newEnd);
    }
}

