/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.io.buffer.SegmentedResult;
import com.aoindustries.util.AoArrays;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;

public class SegmentedWriter
extends BufferWriter {
    private static final Logger logger = Logger.getLogger(SegmentedWriter.class.getName());
    private static final int START_LEN = 16;
    static final byte TYPE_STRING = 1;
    static final byte TYPE_CHAR_NEWLINE = 2;
    static final byte TYPE_CHAR_QUOTE = 3;
    static final byte TYPE_CHAR_APOS = 4;
    static final byte TYPE_CHAR_OTHER = 5;
    private long length = 0L;
    private byte[] segmentTypes = AoArrays.EMPTY_BYTE_ARRAY;
    private Object[] segmentValues = AoArrays.EMPTY_OBJECT_ARRAY;
    private int[] segmentOffsets = AoArrays.EMPTY_INT_ARRAY;
    private int[] segmentLengths = AoArrays.EMPTY_INT_ARRAY;
    private int segmentCount = 0;
    private boolean isClosed = false;
    private BufferResult result;

    private void writeSegment(int segmentIndex, Writer out) throws IOException {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                out.write((String)this.segmentValues[segmentIndex], this.segmentOffsets[segmentIndex], this.segmentLengths[segmentIndex]);
                break;
            }
            case 2: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(10);
                break;
            }
            case 3: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(34);
                break;
            }
            case 4: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(39);
                break;
            }
            case 5: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(((Character)this.segmentValues[segmentIndex]).charValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void addSegment(byte type, Object value, int off, int len) {
        assert (!this.isClosed);
        assert (len > 0) : "Empty segments should never be added";
        int arraylen = this.segmentValues.length;
        if (this.segmentCount == arraylen) {
            if (arraylen == 0) {
                this.segmentTypes = new byte[16];
                this.segmentValues = new Object[16];
                this.segmentOffsets = new int[16];
                this.segmentLengths = new int[16];
            } else {
                int newLen = arraylen << 1;
                byte[] newTypes = new byte[newLen];
                System.arraycopy(this.segmentTypes, 0, newTypes, 0, arraylen);
                this.segmentTypes = newTypes;
                Object[] newValues = new Object[newLen];
                System.arraycopy(this.segmentValues, 0, newValues, 0, arraylen);
                this.segmentValues = newValues;
                int[] newOffsets = new int[newLen];
                System.arraycopy(this.segmentOffsets, 0, newOffsets, 0, arraylen);
                this.segmentOffsets = newOffsets;
                int[] newLengths = new int[newLen];
                System.arraycopy(this.segmentLengths, 0, newLengths, 0, arraylen);
                this.segmentLengths = newLengths;
            }
        }
        this.segmentTypes[this.segmentCount] = type;
        this.segmentValues[this.segmentCount] = value;
        this.segmentOffsets[this.segmentCount] = off;
        this.segmentLengths[this.segmentCount++] = len;
    }

    @Override
    public void write(int c) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        char ch = (char)c;
        switch (ch) {
            case '\n': {
                this.addSegment((byte)2, null, 0, 1);
                break;
            }
            case '\'': {
                this.addSegment((byte)4, null, 0, 1);
                break;
            }
            case '\"': {
                this.addSegment((byte)3, null, 0, 1);
                break;
            }
            default: {
                this.addSegment((byte)5, Character.valueOf(ch), 0, 1);
            }
        }
        ++this.length;
    }

    @Override
    public void write(char[] cbuf) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        int len = cbuf.length;
        if (len > 0) {
            if (len == 1) {
                this.write(cbuf[0]);
            } else {
                this.addSegment((byte)1, new String(cbuf), 0, len);
                this.length += (long)len;
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (len > 0) {
            if (len == 1) {
                this.write(cbuf[off]);
            } else {
                this.addSegment((byte)1, new String(cbuf, off, len), 0, len);
                this.length += (long)len;
            }
        }
    }

    @Override
    public void write(String str) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        int len = str.length();
        if (len > 0) {
            if (len == 1) {
                switch (str.charAt(0)) {
                    case '\n': {
                        this.addSegment((byte)2, null, 0, 1);
                        break;
                    }
                    case '\'': {
                        this.addSegment((byte)4, null, 0, 1);
                        break;
                    }
                    case '\"': {
                        this.addSegment((byte)3, null, 0, 1);
                        break;
                    }
                    default: {
                        this.addSegment((byte)1, str, 0, 1);
                        break;
                    }
                }
            } else {
                this.addSegment((byte)1, str, 0, len);
            }
            this.length += (long)len;
        }
    }

    @Override
    public void write(String str, int off, int len) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (len > 0) {
            if (len == 1) {
                switch (str.charAt(off)) {
                    case '\n': {
                        this.addSegment((byte)2, null, 0, 1);
                        break;
                    }
                    case '\'': {
                        this.addSegment((byte)4, null, 0, 1);
                        break;
                    }
                    case '\"': {
                        this.addSegment((byte)3, null, 0, 1);
                        break;
                    }
                    default: {
                        this.addSegment((byte)1, str, off, 1);
                        break;
                    }
                }
            } else {
                this.addSegment((byte)1, str, off, len);
            }
            this.length += (long)len;
        }
    }

    @Override
    public SegmentedWriter append(CharSequence csq) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (csq == null) {
            this.write("null");
        } else {
            int len = csq.length();
            if (len > 0) {
                if (len == 1) {
                    switch (csq.charAt(0)) {
                        case '\n': {
                            this.addSegment((byte)2, null, 0, 1);
                            break;
                        }
                        case '\'': {
                            this.addSegment((byte)4, null, 0, 1);
                            break;
                        }
                        case '\"': {
                            this.addSegment((byte)3, null, 0, 1);
                            break;
                        }
                        default: {
                            this.addSegment((byte)1, csq.toString(), 0, 1);
                            break;
                        }
                    }
                } else {
                    this.addSegment((byte)1, csq.toString(), 0, len);
                }
                this.length += (long)len;
            }
        }
        return this;
    }

    @Override
    public SegmentedWriter append(CharSequence csq, int start, int end) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (csq == null) {
            this.write("null");
        } else {
            int len = end - start;
            if (len > 0) {
                if (len == 1) {
                    char ch = csq.charAt(start);
                    switch (ch) {
                        case '\n': {
                            this.addSegment((byte)2, null, 0, 1);
                            break;
                        }
                        case '\'': {
                            this.addSegment((byte)4, null, 0, 1);
                            break;
                        }
                        case '\"': {
                            this.addSegment((byte)3, null, 0, 1);
                            break;
                        }
                        default: {
                            if (ch <= '\u007f' || !(csq instanceof String)) {
                                this.addSegment((byte)5, Character.valueOf(ch), 0, 1);
                                break;
                            }
                            this.addSegment((byte)1, (String)csq, start, 1);
                            break;
                        }
                    }
                } else if (csq instanceof String) {
                    this.addSegment((byte)1, (String)csq, start, len);
                } else {
                    this.addSegment((byte)1, csq.subSequence(start, end).toString(), 0, len);
                }
                this.length += (long)len;
            }
        }
        return this;
    }

    @Override
    public SegmentedWriter append(char c) throws ClosedChannelException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        switch (c) {
            case '\n': {
                this.addSegment((byte)2, null, 0, 1);
                break;
            }
            case '\'': {
                this.addSegment((byte)4, null, 0, 1);
                break;
            }
            case '\"': {
                this.addSegment((byte)3, null, 0, 1);
                break;
            }
            default: {
                this.addSegment((byte)5, Character.valueOf(c), 0, 1);
            }
        }
        ++this.length;
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return "SegmentedWriter(length=" + this.length + ", count=" + this.segmentCount + ", capacity=" + this.segmentValues.length + ")";
    }

    @Override
    public BufferResult getResult() throws IllegalStateException {
        if (!this.isClosed) {
            throw new IllegalStateException();
        }
        if (this.result == null) {
            if (this.length == 0L) {
                this.result = EmptyResult.getInstance();
            } else {
                assert (this.segmentCount > 0) : "When not empty and using segments, must have at least one segment";
                int endSegmentIndex = this.segmentCount - 1;
                this.result = new SegmentedResult(this.segmentTypes, this.segmentValues, this.segmentOffsets, this.segmentLengths, 0L, 0, this.segmentOffsets[0], this.segmentLengths[0], this.length, endSegmentIndex, this.segmentOffsets[endSegmentIndex], this.segmentLengths[endSegmentIndex]);
            }
        }
        return this.result;
    }
}

