/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.Encoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.lang.NotImplementedException;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;

public class SegmentedResult
implements BufferResult {
    private static final Logger logger = Logger.getLogger(SegmentedResult.class.getName());
    private final byte[] segmentTypes;
    private final Object[] segmentValues;
    private final int[] segmentOffsets;
    private final int[] segmentLengths;
    private final long start;
    private final int startSegmentIndex;
    private final int startSegmentOffset;
    private final int startSegmentLength;
    private final long end;
    private final int endSegmentIndex;
    private final int endSegmentOffset;
    private final int endSegmentLength;
    private String toStringCache;

    private static void assertThingsMakeSense(long start, int startSegmentIndex, int startSegmentOffset, int startSegmentLength, long end, int endSegmentIndex, int endSegmentOffset, int endSegmentLength) {
        assert (start <= end);
        assert (startSegmentIndex <= endSegmentIndex);
        if (startSegmentIndex == endSegmentIndex) {
            assert (startSegmentOffset == endSegmentOffset);
            assert (startSegmentLength == endSegmentLength);
        }
    }

    protected SegmentedResult(byte[] segmentTypes, Object[] segmentValues, int[] segmentOffsets, int[] segmentLengths, long start, int startSegmentIndex, int startSegmentOffset, int startSegmentLength, long end, int endSegmentIndex, int endSegmentOffset, int endSegmentLength) {
        SegmentedResult.assertThingsMakeSense(start, startSegmentIndex, startSegmentOffset, startSegmentLength, end, endSegmentIndex, endSegmentOffset, endSegmentLength);
        this.segmentTypes = segmentTypes;
        this.segmentValues = segmentValues;
        this.segmentOffsets = segmentOffsets;
        this.segmentLengths = segmentLengths;
        this.start = start;
        this.startSegmentIndex = startSegmentIndex;
        this.startSegmentOffset = startSegmentOffset;
        assert (startSegmentLength > 0) : "All empty results should have been converted to EmptyResult";
        this.startSegmentLength = startSegmentLength;
        this.end = end;
        assert (endSegmentIndex >= startSegmentIndex);
        this.endSegmentIndex = endSegmentIndex;
        this.endSegmentOffset = endSegmentOffset;
        assert (endSegmentLength > 0) : "All empty results should have been converted to EmptyResult";
        this.endSegmentLength = endSegmentLength;
        assert (endSegmentIndex != startSegmentIndex || startSegmentOffset == endSegmentOffset && startSegmentLength == endSegmentLength) : "When start and end segments are at the same index, they must have the same offsets and lengths.";
    }

    public long getLength() {
        return this.end - this.start;
    }

    private void append(int segmentIndex, StringBuilder buffer) {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                int off = this.segmentOffsets[segmentIndex];
                buffer.append((String)this.segmentValues[segmentIndex], off, off + this.segmentLengths[segmentIndex]);
                break;
            }
            case 2: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                buffer.append('\n');
                break;
            }
            case 3: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                buffer.append('\"');
                break;
            }
            case 4: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                buffer.append('\'');
                break;
            }
            case 5: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                buffer.append(((Character)this.segmentValues[segmentIndex]).charValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void append(int segmentIndex, int off, int len, StringBuilder buffer) {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                buffer.append((String)this.segmentValues[segmentIndex], off, off + len);
                break;
            }
            case 2: {
                assert (off == 0);
                assert (len == 1);
                buffer.append('\n');
                break;
            }
            case 3: {
                assert (off == 0);
                assert (len == 1);
                buffer.append('\"');
                break;
            }
            case 4: {
                assert (off == 0);
                assert (len == 1);
                buffer.append('\'');
                break;
            }
            case 5: {
                assert (off == 0);
                assert (len == 1);
                buffer.append(((Character)this.segmentValues[segmentIndex]).charValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeSegment(int segmentIndex, Encoder encoder, Writer out) throws IOException {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                encoder.write((String)this.segmentValues[segmentIndex], this.segmentOffsets[segmentIndex], this.segmentLengths[segmentIndex], out);
                break;
            }
            case 2: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                encoder.write(10, out);
                break;
            }
            case 3: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                encoder.write(34, out);
                break;
            }
            case 4: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                encoder.write(39, out);
                break;
            }
            case 5: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                encoder.write((int)((Character)this.segmentValues[segmentIndex]).charValue(), out);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeSegment(int segmentIndex, int off, int len, Encoder encoder, Writer out) throws IOException {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                encoder.write((String)this.segmentValues[segmentIndex], off, len, out);
                break;
            }
            case 2: {
                assert (off == 0);
                assert (len == 1);
                encoder.write(10, out);
                break;
            }
            case 3: {
                assert (off == 0);
                assert (len == 1);
                encoder.write(34, out);
                break;
            }
            case 4: {
                assert (off == 0);
                assert (len == 1);
                encoder.write(39, out);
                break;
            }
            case 5: {
                assert (off == 0);
                assert (len == 1);
                encoder.write((int)((Character)this.segmentValues[segmentIndex]).charValue(), out);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeSegment(int segmentIndex, Writer out) throws IOException {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                out.write((String)this.segmentValues[segmentIndex], this.segmentOffsets[segmentIndex], this.segmentLengths[segmentIndex]);
                break;
            }
            case 2: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(10);
                break;
            }
            case 3: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(34);
                break;
            }
            case 4: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(39);
                break;
            }
            case 5: {
                assert (this.segmentOffsets[segmentIndex] == 0);
                assert (this.segmentLengths[segmentIndex] == 1);
                out.write(((Character)this.segmentValues[segmentIndex]).charValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void writeSegment(int segmentIndex, int off, int len, Writer out) throws IOException {
        switch (this.segmentTypes[segmentIndex]) {
            case 1: {
                out.write((String)this.segmentValues[segmentIndex], off, len);
                break;
            }
            case 2: {
                assert (off == 0);
                assert (len == 1);
                out.write(10);
                break;
            }
            case 3: {
                assert (off == 0);
                assert (len == 1);
                out.write(34);
                break;
            }
            case 4: {
                assert (off == 0);
                assert (len == 1);
                out.write(39);
                break;
            }
            case 5: {
                assert (off == 0);
                assert (len == 1);
                out.write(((Character)this.segmentValues[segmentIndex]).charValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static char charAt(byte type, Object value, int charIndex) {
        switch (type) {
            case 1: {
                return ((String)value).charAt(charIndex);
            }
            case 2: {
                assert (charIndex == 0);
                return '\n';
            }
            case 3: {
                assert (charIndex == 0);
                return '\"';
            }
            case 4: {
                assert (charIndex == 0);
                return '\'';
            }
            case 5: {
                assert (charIndex == 0);
                return ((Character)value).charValue();
            }
        }
        throw new AssertionError();
    }

    public boolean isFastToString() {
        if (this.toStringCache != null) {
            return true;
        }
        if (this.startSegmentIndex != this.endSegmentIndex) {
            return false;
        }
        switch (this.segmentTypes[this.startSegmentIndex]) {
            case 1: {
                if (this.startSegmentOffset != 0) {
                    return false;
                }
                String str = (String)this.segmentValues[this.startSegmentIndex];
                return this.startSegmentLength == str.length();
            }
            case 2: {
                assert (this.startSegmentOffset == 0);
                assert (this.startSegmentLength == 1);
                return true;
            }
            case 3: {
                assert (this.startSegmentOffset == 0);
                assert (this.startSegmentLength == 1);
                return true;
            }
            case 4: {
                assert (this.startSegmentOffset == 0);
                assert (this.startSegmentLength == 1);
                return true;
            }
            case 5: {
                assert (this.startSegmentOffset == 0);
                assert (this.startSegmentLength == 1);
                return true;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        block18: {
            block19: {
                if (this.toStringCache != null) break block18;
                if (this.startSegmentIndex != this.endSegmentIndex) break block19;
                switch (this.segmentTypes[this.startSegmentIndex]) {
                    case 1: {
                        this.toStringCache = ((String)this.segmentValues[this.startSegmentIndex]).substring(this.startSegmentOffset, this.startSegmentOffset + this.startSegmentLength);
                        break block18;
                    }
                    case 2: {
                        assert (this.startSegmentOffset == 0);
                        assert (this.startSegmentLength == 1);
                        this.toStringCache = "\n";
                        break block18;
                    }
                    case 3: {
                        assert (this.startSegmentOffset == 0);
                        assert (this.startSegmentLength == 1);
                        this.toStringCache = "\"";
                        break block18;
                    }
                    case 4: {
                        assert (this.startSegmentOffset == 0);
                        assert (this.startSegmentLength == 1);
                        this.toStringCache = "'";
                        break block18;
                    }
                    case 5: {
                        assert (this.startSegmentOffset == 0);
                        assert (this.startSegmentLength == 1);
                        this.toStringCache = String.valueOf(((Character)this.segmentValues[this.startSegmentIndex]).charValue());
                        break block18;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            logger.fine("Creating String from segments - benefits of SegmentedWriter negated.");
            long length = this.end - this.start;
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("Buffer too large to convert to String: length=" + length);
            }
            StringBuilder buffer = new StringBuilder((int)length);
            this.append(this.startSegmentIndex, this.startSegmentOffset, this.startSegmentLength, buffer);
            for (int i = this.startSegmentIndex + 1; i < this.endSegmentIndex; ++i) {
                this.append(i, buffer);
            }
            this.append(this.endSegmentIndex, this.endSegmentOffset, this.endSegmentLength, buffer);
            assert ((long)buffer.length() == length) : "buffer.length()!=length: " + buffer.length() + "!=" + length;
            this.toStringCache = buffer.toString();
        }
        return this.toStringCache;
    }

    public void writeTo(Writer out) throws IOException {
        this.writeSegment(this.startSegmentIndex, this.startSegmentOffset, this.startSegmentLength, out);
        if (this.endSegmentIndex != this.startSegmentIndex) {
            int i = this.startSegmentIndex + 1;
            if (i < this.endSegmentIndex) {
                do {
                    this.writeSegment(i++, out);
                } while (i < this.endSegmentIndex);
            }
            this.writeSegment(this.endSegmentIndex, this.endSegmentOffset, this.endSegmentLength, out);
        }
    }

    public void writeTo(Writer out, long off, long len) throws IOException {
        throw new NotImplementedException("Implement when first needed.");
    }

    public void writeTo(Encoder encoder, Writer out) throws IOException {
        if (encoder == null) {
            this.writeTo(out);
        } else {
            this.writeSegment(this.startSegmentIndex, this.startSegmentOffset, this.startSegmentLength, encoder, out);
            if (this.endSegmentIndex != this.startSegmentIndex) {
                for (int i = this.startSegmentIndex + 1; i < this.endSegmentIndex; ++i) {
                    this.writeSegment(i, encoder, out);
                }
                this.writeSegment(this.endSegmentIndex, this.endSegmentOffset, this.endSegmentLength, encoder, out);
            }
        }
    }

    public void writeTo(Encoder encoder, Writer out, long off, long len) throws IOException {
        throw new NotImplementedException("Implement when first needed.");
    }

    @Override
    public BufferResult trim() throws IOException {
        char ch;
        Object value;
        byte type;
        long newStart = this.start;
        int newStartSegmentIndex = this.startSegmentIndex;
        int newStartSegmentOffset = this.startSegmentOffset;
        int newStartSegmentLength = this.startSegmentLength;
        long newEnd = this.end;
        int newEndSegmentIndex = this.endSegmentIndex;
        int newEndSegmentOffset = this.endSegmentOffset;
        int newEndSegmentLength = this.endSegmentLength;
        SegmentedResult.assertThingsMakeSense(newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
        block0: while (newStart < newEnd) {
            type = this.segmentTypes[newStartSegmentIndex];
            value = this.segmentValues[newStartSegmentIndex];
            while (Character.isWhitespace(ch = SegmentedResult.charAt(type, value, newStartSegmentOffset))) {
                ++newStart;
                ++newStartSegmentOffset;
                --newStartSegmentLength;
                if (newStartSegmentIndex == newEndSegmentIndex) {
                    ++newEndSegmentOffset;
                    --newEndSegmentLength;
                }
                SegmentedResult.assertThingsMakeSense(newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
                if (newEnd == newStart) break block0;
                if (newStartSegmentLength > 0) continue;
                if (++newStartSegmentIndex == newEndSegmentIndex) {
                    newStartSegmentOffset = newEndSegmentOffset;
                    newStartSegmentLength = newEndSegmentLength;
                } else {
                    newStartSegmentOffset = this.segmentOffsets[newStartSegmentIndex];
                    newStartSegmentLength = this.segmentLengths[newStartSegmentIndex];
                }
                SegmentedResult.assertThingsMakeSense(newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
                continue block0;
            }
            break block0;
        }
        if (newEnd > newStart) {
            assert (newEndSegmentIndex >= 0);
            type = this.segmentTypes[newEndSegmentIndex];
            value = this.segmentValues[newEndSegmentIndex];
            while (Character.isWhitespace(ch = SegmentedResult.charAt(type, value, newEndSegmentOffset + newEndSegmentLength - 1))) {
                --newEnd;
                --newEndSegmentLength;
                if (newStartSegmentIndex == newEndSegmentIndex) {
                    --newStartSegmentLength;
                }
                SegmentedResult.assertThingsMakeSense(newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
                if (newEnd == newStart) break;
                if (newEndSegmentLength > 0) continue;
                assert (--newEndSegmentIndex >= 0) : "Must be non-negative because we have not made it back to newStart yet";
                type = this.segmentTypes[newEndSegmentIndex];
                value = this.segmentValues[newEndSegmentIndex];
                if (newEndSegmentIndex == newStartSegmentIndex) {
                    newEndSegmentOffset = newStartSegmentOffset;
                    newEndSegmentLength = newStartSegmentLength;
                } else {
                    newEndSegmentOffset = this.segmentOffsets[newEndSegmentIndex];
                    newEndSegmentLength = this.segmentLengths[newEndSegmentIndex];
                }
                SegmentedResult.assertThingsMakeSense(newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
            }
        }
        if (this.start == newStart && this.end == newEnd) {
            return this;
        }
        if (newStart == newEnd) {
            return EmptyResult.getInstance();
        }
        return new SegmentedResult(this.segmentTypes, this.segmentValues, this.segmentOffsets, this.segmentLengths, newStart, newStartSegmentIndex, newStartSegmentOffset, newStartSegmentLength, newEnd, newEndSegmentIndex, newEndSegmentOffset, newEndSegmentLength);
    }
}

