/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.LoggingResult;
import com.aoindustries.util.AtomicSequence;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.WrappedException;
import java.io.IOException;
import java.io.Writer;

public class LoggingWriter
extends BufferWriter {
    private static final Sequence idSeq = new AtomicSequence();
    private final long id = idSeq.getNextSequenceValue();
    private final BufferWriter wrapped;
    private final Writer log;
    private LoggingResult result;

    public LoggingWriter(BufferWriter wrapped, Writer log) throws IOException {
        log.write("writer[");
        log.write(Long.toString(this.id));
        log.write("] = factory.newBufferWriter();\n");
        log.flush();
        this.wrapped = wrapped;
        this.log = log;
    }

    public long getId() {
        return this.id;
    }

    private void log(char ch) throws IOException {
        if (ch == '\t') {
            this.log.write("'\\t'");
        } else if (ch == '\b') {
            this.log.write("'\\b'");
        } else if (ch == '\n') {
            this.log.write("'\\n'");
        } else if (ch == '\r') {
            this.log.write("'\\r'");
        } else if (ch == '\f') {
            this.log.write("'\\f'");
        } else if (ch == '\'') {
            this.log.write("'\\'");
        } else if (ch == '\\') {
            this.log.write("'\\\\'");
        } else if (ch == '\"') {
            this.log.write("'\\\"'");
        } else if (ch < ' ') {
            this.log.write("'\\u");
            String hex = Integer.toHexString(ch);
            for (int l = hex.length(); l < 4; ++l) {
                this.log.write(48);
            }
            this.log.write(hex);
            this.log.write(39);
        } else {
            this.log.write(39);
            this.log.write(ch);
            this.log.write(39);
        }
    }

    private void log(String value) throws IOException {
        if (value == null) {
            this.log.write("(String)null");
        } else {
            this.log.write(34);
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == '\t') {
                    this.log.write("\\t");
                    continue;
                }
                if (ch == '\b') {
                    this.log.write("\\b");
                    continue;
                }
                if (ch == '\n') {
                    this.log.write("\\n");
                    continue;
                }
                if (ch == '\r') {
                    this.log.write("\\r");
                    continue;
                }
                if (ch == '\f') {
                    this.log.write("\\f");
                    continue;
                }
                if (ch == '\\') {
                    this.log.write("\\\\");
                    continue;
                }
                if (ch == '\"') {
                    this.log.write("\\\"");
                    continue;
                }
                if (ch < ' ') {
                    this.log.write("\\u");
                    String hex = Integer.toHexString(ch);
                    for (int l = hex.length(); l < 4; ++l) {
                        this.log.write(48);
                    }
                    this.log.write(hex);
                    continue;
                }
                this.log.write(ch);
            }
            this.log.write(34);
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].write(");
        this.log.write(Integer.toString(c));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].write(");
        this.log(new String(cbuf));
        this.log.write(".toCharArray());\n");
        this.log.flush();
        this.wrapped.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].write(");
        this.log(new String(cbuf, 0, off + len));
        this.log.write(".toCharArray(), ");
        this.log.write(Integer.toString(off));
        this.log.write(", ");
        this.log.write(Integer.toString(len));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].write(");
        this.log(str);
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].write(");
        this.log(str);
        this.log.write(", ");
        this.log.write(Integer.toString(off));
        this.log.write(", ");
        this.log.write(Integer.toString(len));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.write(str, off, len);
    }

    @Override
    public LoggingWriter append(CharSequence csq) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].append(");
        this.log(csq == null ? null : csq.toString());
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.append(csq);
        return this;
    }

    @Override
    public LoggingWriter append(CharSequence csq, int start, int end) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].append(");
        this.log(csq == null ? null : csq.toString());
        this.log.write(", ");
        this.log.write(Integer.toString(start));
        this.log.write(", ");
        this.log.write(Integer.toString(end));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.append(csq, start, end);
        return this;
    }

    @Override
    public LoggingWriter append(char c) throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].append(");
        this.log(c);
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].flush();\n");
        this.log.flush();
        this.wrapped.flush();
    }

    @Override
    public void close() throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].close();\n");
        this.log.flush();
        this.wrapped.close();
    }

    @Override
    public long getLength() throws IOException {
        this.log.write("writer[");
        this.log.write(Long.toString(this.id));
        this.log.write("].getLength();\n");
        this.log.flush();
        return this.wrapped.getLength();
    }

    @Override
    public String toString() {
        try {
            this.log.write("writer[");
            this.log.write(Long.toString(this.id));
            this.log.write("].toString();\n");
            this.log.flush();
        }
        catch (IOException e) {
            throw new WrappedException((Throwable)e);
        }
        return "LoggingWriter(" + this.wrapped.toString() + ")";
    }

    @Override
    public LoggingResult getResult() throws IllegalStateException, IOException {
        if (this.result == null) {
            this.result = new LoggingResult(this.wrapped.getResult(), this.log);
            this.log.write("result[");
            this.log.write(Long.toString(this.result.id));
            this.log.write("] = writer[");
            this.log.write(Long.toString(this.id));
            this.log.write("].getResult();\n");
            this.log.flush();
        }
        return this.result;
    }
}

