/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.CharArrayBufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.BufferManager;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;

public class CharArrayBufferWriter
extends BufferWriter {
    private static final int MAX_LENGTH = 0x40000000;
    private static final int COPY_THEN_RECYCLE_LIMIT = 512;
    private int length = 0;
    private char[] buffer = AoArrays.EMPTY_CHAR_ARRAY;
    private boolean isClosed = false;
    private BufferResult result;

    private char[] getBuffer(int additional) throws IOException {
        long newLen = (long)this.length + (long)additional;
        if (newLen > 0x40000000L) {
            throw new IOException("Maximum buffer length is 1073741824, " + newLen + " requested");
        }
        char[] buf = this.buffer;
        int bufLen = buf.length;
        if (newLen > (long)bufLen) {
            int newBufLen;
            int n = newBufLen = bufLen == 0 ? 4096 : bufLen << 1;
            while ((long)newBufLen < newLen) {
                newBufLen <<= 1;
            }
            char[] newBuf = newBufLen == 4096 ? BufferManager.getChars() : new char[newBufLen];
            System.arraycopy(buf, 0, newBuf, 0, this.length);
            if (bufLen == 4096) {
                // empty if block
            }
            this.buffer = buf = newBuf;
        }
        return buf;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.getBuffer((int)1)[this.length++] = (char)c;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (len > 0) {
            char[] buf = this.getBuffer(len);
            System.arraycopy(cbuf, off, buf, this.length, len);
            this.length += len;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        if (len > 0) {
            char[] buf = this.getBuffer(len);
            str.getChars(off, off + len, buf, this.length);
            this.length += len;
        }
    }

    @Override
    public CharArrayBufferWriter append(CharSequence csq) throws IOException {
        super.append(csq);
        return this;
    }

    @Override
    public CharArrayBufferWriter append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            this.write("null");
        } else if (csq instanceof String) {
            this.write((String)csq, start, end - start);
        } else {
            this.write(csq.subSequence(start, end).toString());
        }
        return this;
    }

    @Override
    public CharArrayBufferWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        int len = this.length;
        if (len > 0 && len <= 512) {
            char[] oldBuf = this.buffer;
            this.buffer = Arrays.copyOf(oldBuf, len);
            if (oldBuf.length == 4096) {
                BufferManager.release((char[])oldBuf, (boolean)false);
            }
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return "CharArrayBufferWriter(length=" + this.length + ")";
    }

    @Override
    public BufferResult getResult() throws IllegalStateException {
        if (!this.isClosed) {
            throw new IllegalStateException();
        }
        if (this.result == null) {
            this.result = this.length == 0 ? EmptyResult.getInstance() : new CharArrayBufferResult(this.buffer, 0, this.length);
        }
        return this.result;
    }
}

