/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.Encoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.math.SafeMath;
import java.io.IOException;
import java.io.Writer;

public class CharArrayBufferResult
implements BufferResult {
    private final char[] buffer;
    private final int start;
    private final int end;
    private String toStringCache;

    protected CharArrayBufferResult(char[] buffer, int start, int end) {
        this.buffer = buffer;
        this.start = start;
        this.end = end;
    }

    public long getLength() {
        return this.end - this.start;
    }

    public boolean isFastToString() {
        return this.toStringCache != null;
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = new String(this.buffer, this.start, this.end - this.start);
        }
        return this.toStringCache;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buffer, this.start, this.end - this.start);
    }

    public void writeTo(Writer out, long off, long len) throws IOException {
        if ((long)this.start + off + len > (long)this.end) {
            throw new IndexOutOfBoundsException();
        }
        out.write(this.buffer, SafeMath.castInt((long)((long)this.start + off)), SafeMath.castInt((long)len));
    }

    public void writeTo(Encoder encoder, Writer out) throws IOException {
        if (encoder == null) {
            this.writeTo(out);
        } else {
            encoder.write(this.buffer, this.start, this.end - this.start, out);
        }
    }

    public void writeTo(Encoder encoder, Writer out, long off, long len) throws IOException {
        if (encoder == null) {
            this.writeTo(out, off, len);
        } else {
            if ((long)this.start + off + len > (long)this.end) {
                throw new IndexOutOfBoundsException();
            }
            encoder.write(this.buffer, SafeMath.castInt((long)((long)this.start + off)), SafeMath.castInt((long)len), out);
        }
    }

    @Override
    public BufferResult trim() throws IOException {
        char ch;
        int newEnd;
        char ch2;
        int newStart;
        char[] buf = this.buffer;
        for (newStart = this.start; newStart < this.end && Character.isWhitespace(ch2 = buf[newStart]); ++newStart) {
        }
        for (newEnd = this.end; newEnd > newStart && Character.isWhitespace(ch = buf[newEnd - 1]); --newEnd) {
        }
        if (this.start == newStart && this.end == newEnd) {
            return this;
        }
        if (newStart == newEnd) {
            return EmptyResult.getInstance();
        }
        return new CharArrayBufferResult(this.buffer, newStart, newEnd);
    }
}

