/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.TempFile;
import com.aoindustries.io.TempFileList;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.TempFileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoTempFileWriter
extends BufferWriter {
    private static final Logger logger = Logger.getLogger(AutoTempFileWriter.class.getName());
    public static final long DEFAULT_TEMP_FILE_THRESHOLD = 0x400000L;
    private final TempFileList tempFileList;
    private final long tempFileThreshold;
    private BufferWriter buffer;
    private boolean isInitialBuffer;

    public AutoTempFileWriter(BufferWriter initialBuffer, TempFileList tempFileList, long tempFileThreshold) {
        this.tempFileList = tempFileList;
        this.tempFileThreshold = tempFileThreshold;
        this.buffer = initialBuffer;
        this.isInitialBuffer = !(initialBuffer instanceof TempFileWriter);
    }

    public AutoTempFileWriter(BufferWriter initialBuffer, TempFileList tempFileList) {
        this(initialBuffer, tempFileList, 0x400000L);
    }

    private void switchIfNeeded(long newLength) throws IOException {
        if (this.isInitialBuffer && newLength >= this.tempFileThreshold) {
            TempFile tempFile = this.tempFileList.createTempFile();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Switching to temp file: {0}", tempFile);
            }
            this.buffer.close();
            TempFileWriter tempFileWriter = new TempFileWriter(tempFile);
            this.buffer.getResult().writeTo(tempFileWriter);
            this.buffer = tempFileWriter;
            this.isInitialBuffer = false;
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + 1L);
        }
        this.buffer.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)cbuf.length);
        }
        this.buffer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)len);
        }
        this.buffer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)str.length());
        }
        this.buffer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)len);
        }
        this.buffer.write(str, off, len);
    }

    @Override
    public AutoTempFileWriter append(CharSequence csq) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)csq.length());
        }
        this.buffer.append(csq);
        return this;
    }

    @Override
    public AutoTempFileWriter append(CharSequence csq, int start, int end) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + (long)(end - start));
        }
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public AutoTempFileWriter append(char c) throws IOException {
        if (this.isInitialBuffer) {
            this.switchIfNeeded(this.buffer.getLength() + 1L);
        }
        this.buffer.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    @Override
    public long getLength() throws IOException {
        return this.buffer.getLength();
    }

    @Override
    public String toString() {
        return "AutoTempFileWriter(" + this.buffer + ", " + this.tempFileThreshold + ")";
    }

    @Override
    public BufferResult getResult() throws IllegalStateException, IOException {
        return this.buffer.getResult();
    }
}

