/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.ApplicationResources;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.MediaValidator;
import java.io.IOException;
import java.io.Writer;

public class XhtmlAttributeValidator
extends MediaValidator {
    public static void checkCharacter(char c) throws IOException {
        if (!(c != '<' && c != '>' && c != '\'' && c != '\"' && (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\ud800' && c <= '\udfff'))) {
            throw new IOException(ApplicationResources.accessor.getMessage("XhtmlAttributeValidator.invalidCharacter", new Object[]{Integer.toHexString(c)}));
        }
    }

    public static void checkCharacters(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            XhtmlAttributeValidator.checkCharacter(cbuf[off++]);
        }
    }

    public static void checkCharacters(CharSequence str, int off, int end) throws IOException {
        while (off < end) {
            XhtmlAttributeValidator.checkCharacter(str.charAt(off++));
        }
    }

    protected XhtmlAttributeValidator(Writer out) {
        super(out);
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.XHTML_ATTRIBUTE || inputType == MediaType.XHTML || inputType == MediaType.TEXT;
    }

    @Override
    public boolean canSkipValidation(MediaType inputType) {
        return inputType == MediaType.XHTML_ATTRIBUTE;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML_ATTRIBUTE;
    }

    @Override
    public void write(int c) throws IOException {
        XhtmlAttributeValidator.checkCharacter((char)c);
        this.out.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        XhtmlAttributeValidator.checkCharacters(cbuf, off, len);
        this.out.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        XhtmlAttributeValidator.checkCharacters(str, off, off + len);
        this.out.write(str, off, len);
    }

    @Override
    public XhtmlAttributeValidator append(CharSequence csq) throws IOException {
        XhtmlAttributeValidator.checkCharacters(csq, 0, csq.length());
        this.out.append(csq);
        return this;
    }

    @Override
    public XhtmlAttributeValidator append(CharSequence csq, int start, int end) throws IOException {
        XhtmlAttributeValidator.checkCharacters(csq, start, end);
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public XhtmlAttributeValidator append(char c) throws IOException {
        XhtmlAttributeValidator.checkCharacter(c);
        this.out.append(c);
        return this;
    }
}

