/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.ApplicationResources;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.MediaValidator;
import java.io.IOException;
import java.io.Writer;

public class UrlValidator
extends MediaValidator {
    private boolean foundQuestionMark = false;

    public static boolean checkCharacter(int c, boolean foundQuestionMark) throws IOException {
        if (foundQuestionMark) {
            switch (c) {
                case 35: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 61: 
                case 95: {
                    return true;
                }
            }
            if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57)) {
                throw new IOException(ApplicationResources.accessor.getMessage("UrlValidator.invalidCharacter", new Object[]{Integer.toHexString(c)}));
            }
            return true;
        }
        return c == 63;
    }

    public static boolean checkCharacters(char[] cbuf, int off, int len, boolean foundQuestionMark) throws IOException {
        int end = off + len;
        while (off < end) {
            foundQuestionMark = UrlValidator.checkCharacter(cbuf[off++], foundQuestionMark);
        }
        return foundQuestionMark;
    }

    public static boolean checkCharacters(CharSequence str, int off, int end, boolean foundQuestionMark) throws IOException {
        while (off < end) {
            foundQuestionMark = UrlValidator.checkCharacter(str.charAt(off++), foundQuestionMark);
        }
        return foundQuestionMark;
    }

    protected UrlValidator(Writer out) {
        super(out);
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.URL || inputType == MediaType.TEXT;
    }

    @Override
    public boolean canSkipValidation(MediaType inputType) {
        return inputType == MediaType.URL;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.URL;
    }

    @Override
    public void write(int c) throws IOException {
        this.foundQuestionMark = UrlValidator.checkCharacter(c, this.foundQuestionMark);
        this.out.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.foundQuestionMark = UrlValidator.checkCharacters(cbuf, off, len, this.foundQuestionMark);
        this.out.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        this.foundQuestionMark = UrlValidator.checkCharacters(str, off, off + len, this.foundQuestionMark);
        this.out.write(str, off, len);
    }

    @Override
    public UrlValidator append(CharSequence csq) throws IOException {
        this.foundQuestionMark = UrlValidator.checkCharacters(csq, 0, csq.length(), this.foundQuestionMark);
        this.out.append(csq);
        return this;
    }

    @Override
    public UrlValidator append(CharSequence csq, int start, int end) throws IOException {
        this.foundQuestionMark = UrlValidator.checkCharacters(csq, start, end, this.foundQuestionMark);
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public UrlValidator append(char c) throws IOException {
        this.foundQuestionMark = UrlValidator.checkCharacter(c, this.foundQuestionMark);
        this.out.append(c);
        return this;
    }
}

