/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.BufferedEncoder;
import com.aoindustries.encoding.EncodingContext;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInJavaScriptEncoder;
import java.io.IOException;

public class UrlInJavaScriptEncoder
extends BufferedEncoder {
    private final MediaType outputType;
    private final EncodingContext context;

    UrlInJavaScriptEncoder(MediaType outputType, EncodingContext context) {
        super(128);
        if (outputType != MediaType.JAVASCRIPT && outputType != MediaType.JSON && outputType != MediaType.LD_JSON) {
            throw new IllegalArgumentException("Unsupported output type: " + (Object)((Object)outputType));
        }
        this.outputType = outputType;
        this.context = context;
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.URL || inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return this.outputType;
    }

    @Override
    public void writePrefixTo(Appendable out) throws IOException {
        out.append('\"');
    }

    @Override
    protected void writeSuffix(StringBuilder buffer, Appendable out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(this.context.encodeURL(buffer.toString()), out);
        out.append('\"');
    }
}

