/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.XhtmlAttributeValidator;
import java.io.IOException;
import java.io.Writer;

public class TextInXhtmlAttributeEncoder
extends MediaEncoder {
    public static final TextInXhtmlAttributeEncoder textInXhtmlAttributeEncoder = new TextInXhtmlAttributeEncoder();

    private static String getEscapedCharacter(char c) throws IOException {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\'': {
                return "&#39;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\t': {
                return "&#x9;";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\n': {
                return "&#xA;";
            }
        }
        XhtmlAttributeValidator.checkCharacter(c);
        return null;
    }

    public static void encodeTextInXhtmlAttribute(char ch, Appendable out) throws IOException {
        String escaped = TextInXhtmlAttributeEncoder.getEscapedCharacter(ch);
        if (escaped != null) {
            out.append(escaped);
        } else {
            out.append(ch);
        }
    }

    public static void encodeTextInXhtmlAttribute(char[] cbuf, Writer out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(cbuf, 0, cbuf.length, out);
    }

    public static void encodeTextInXhtmlAttribute(char[] cbuf, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int toPrint = 0;
        for (int c = start; c < end; ++c) {
            String escaped = TextInXhtmlAttributeEncoder.getEscapedCharacter(cbuf[c]);
            if (escaped != null) {
                if (toPrint > 0) {
                    out.write(cbuf, c - toPrint, toPrint);
                    toPrint = 0;
                }
                out.write(escaped);
                continue;
            }
            ++toPrint;
        }
        if (toPrint > 0) {
            out.write(cbuf, end - toPrint, toPrint);
        }
    }

    public static void encodeTextInXhtmlAttribute(CharSequence S, Appendable out) throws IOException {
        if (S != null) {
            TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(S, 0, S.length(), out);
        }
    }

    public static void encodeTextInXhtmlAttribute(CharSequence S, int start, int end, Appendable out) throws IOException {
        if (S != null) {
            int toPrint = 0;
            for (int c = start; c < end; ++c) {
                String escaped = TextInXhtmlAttributeEncoder.getEscapedCharacter(S.charAt(c));
                if (escaped != null) {
                    if (toPrint > 0) {
                        out.append(S, c - toPrint, c);
                        toPrint = 0;
                    }
                    out.append(escaped);
                    continue;
                }
                ++toPrint;
            }
            if (toPrint > 0) {
                out.append(S, end - toPrint, end);
            }
        }
    }

    private TextInXhtmlAttributeEncoder() {
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML_ATTRIBUTE;
    }

    @Override
    public void write(int c, Writer out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((char)c, (Appendable)out);
    }

    @Override
    public void write(char[] cbuf, Writer out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(cbuf, out);
    }

    @Override
    public void write(char[] cbuf, int off, int len, Writer out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(cbuf, off, len, out);
    }

    @Override
    public void write(String str, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(str, (Appendable)out);
    }

    @Override
    public void write(String str, int off, int len, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(str, off, off + len, (Appendable)out);
    }

    @Override
    public TextInXhtmlAttributeEncoder append(char c, Appendable out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(c, out);
        return this;
    }

    @Override
    public TextInXhtmlAttributeEncoder append(CharSequence csq, Appendable out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(csq == null ? "null" : csq, out);
        return this;
    }

    @Override
    public TextInXhtmlAttributeEncoder append(CharSequence csq, int start, int end, Appendable out) throws IOException {
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(csq == null ? "null" : csq, start, end, out);
        return this;
    }
}

