/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.NewEncodingUtils;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import java.io.IOException;
import java.io.Writer;

public final class JavaScriptInXhtmlEncoder
extends MediaEncoder {
    public static final JavaScriptInXhtmlEncoder javaScriptInXhtmlEncoder = new JavaScriptInXhtmlEncoder(MediaType.JAVASCRIPT);
    public static final JavaScriptInXhtmlEncoder jsonInXhtmlEncoder = new JavaScriptInXhtmlEncoder(MediaType.JSON);
    public static final JavaScriptInXhtmlEncoder ldJsonInXhtmlEncoder = new JavaScriptInXhtmlEncoder(MediaType.LD_JSON);
    private final MediaType contentType;

    private static String getEscapedCharacter(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case '\\': {
                return null;
            }
        }
        return NewEncodingUtils.getJavaScriptUnicodeEscapeString(ch);
    }

    public static void encodeJavaScriptInXhtml(char ch, Appendable out) throws IOException {
        String escaped = JavaScriptInXhtmlEncoder.getEscapedCharacter(ch);
        if (escaped != null) {
            out.append(escaped);
        } else {
            out.append(ch);
        }
    }

    public static void encodeJavaScriptInXhtml(char[] cbuf, Writer out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(cbuf, 0, cbuf.length, out);
    }

    public static void encodeJavaScriptInXhtml(char[] cbuf, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int toPrint = 0;
        for (int c = start; c < end; ++c) {
            String escaped = JavaScriptInXhtmlEncoder.getEscapedCharacter(cbuf[c]);
            if (escaped != null) {
                if (toPrint > 0) {
                    out.write(cbuf, c - toPrint, toPrint);
                    toPrint = 0;
                }
                out.write(escaped);
                continue;
            }
            ++toPrint;
        }
        if (toPrint > 0) {
            out.write(cbuf, end - toPrint, toPrint);
        }
    }

    public static void encodeJavaScriptInXhtml(CharSequence S, Appendable out) throws IOException {
        if (S != null) {
            JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(S, 0, S.length(), out);
        }
    }

    public static void encodeJavaScriptInXhtml(CharSequence S, int start, int end, Appendable out) throws IOException {
        if (S != null) {
            int toPrint = 0;
            for (int c = start; c < end; ++c) {
                String escaped = JavaScriptInXhtmlEncoder.getEscapedCharacter(S.charAt(c));
                if (escaped != null) {
                    if (toPrint > 0) {
                        out.append(S, c - toPrint, c);
                        toPrint = 0;
                    }
                    out.append(escaped);
                    continue;
                }
                ++toPrint;
            }
            if (toPrint > 0) {
                out.append(S, end - toPrint, end);
            }
        }
    }

    private JavaScriptInXhtmlEncoder(MediaType contentType) {
        this.contentType = contentType;
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.JAVASCRIPT || inputType == MediaType.JSON || inputType == MediaType.LD_JSON || inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML;
    }

    @Override
    public void writePrefixTo(Appendable out) throws IOException {
        out.append("<script type=\"");
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute(this.contentType.getContentType(), out);
        out.append("\">\n");
        if (this.contentType == MediaType.JAVASCRIPT) {
            out.append("  // <![CDATA[\n");
        }
    }

    @Override
    public void write(int c, Writer out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml((char)c, (Appendable)out);
    }

    @Override
    public void write(char[] cbuf, Writer out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(cbuf, out);
    }

    @Override
    public void write(char[] cbuf, int off, int len, Writer out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(cbuf, off, len, out);
    }

    @Override
    public void write(String str, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(str, (Appendable)out);
    }

    @Override
    public void write(String str, int off, int len, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(str, off, off + len, (Appendable)out);
    }

    @Override
    public JavaScriptInXhtmlEncoder append(char c, Appendable out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(c, out);
        return this;
    }

    @Override
    public JavaScriptInXhtmlEncoder append(CharSequence csq, Appendable out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(csq == null ? "null" : csq, out);
        return this;
    }

    @Override
    public JavaScriptInXhtmlEncoder append(CharSequence csq, int start, int end, Appendable out) throws IOException {
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(csq == null ? "null" : csq, start, end, out);
        return this;
    }

    @Override
    public void writeSuffixTo(Appendable out) throws IOException {
        if (this.contentType == MediaType.JAVASCRIPT) {
            out.append("  // ]]>\n");
        }
        out.append("</script>");
    }
}

