/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.NewEncodingUtils;
import java.io.IOException;
import java.io.Writer;

public final class JavaScriptInXhtmlAttributeEncoder
extends MediaEncoder {
    public static final JavaScriptInXhtmlAttributeEncoder javaScriptInXhtmlAttributeEncoder = new JavaScriptInXhtmlAttributeEncoder();

    private static String getEscapedCharacter(char ch) {
        switch (ch) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\n': {
                return "&#xA;";
            }
            case '\t': {
                return "&#x9;";
            }
        }
        return NewEncodingUtils.getJavaScriptUnicodeEscapeString(ch);
    }

    public static void encodeJavaScriptInXhtmlAttribute(char ch, Appendable out) throws IOException {
        String escaped = JavaScriptInXhtmlAttributeEncoder.getEscapedCharacter(ch);
        if (escaped != null) {
            out.append(escaped);
        } else {
            out.append(ch);
        }
    }

    public static void encodeJavaScriptInXhtmlAttribute(char[] cbuf, Writer out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(cbuf, 0, cbuf.length, out);
    }

    public static void encodeJavaScriptInXhtmlAttribute(char[] cbuf, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int toPrint = 0;
        for (int c = start; c < end; ++c) {
            String escaped = JavaScriptInXhtmlAttributeEncoder.getEscapedCharacter(cbuf[c]);
            if (escaped != null) {
                if (toPrint > 0) {
                    out.write(cbuf, c - toPrint, toPrint);
                    toPrint = 0;
                }
                out.write(escaped);
                continue;
            }
            ++toPrint;
        }
        if (toPrint > 0) {
            out.write(cbuf, end - toPrint, toPrint);
        }
    }

    public static void encodeJavaScriptInXhtmlAttribute(CharSequence S, Appendable out) throws IOException {
        if (S != null) {
            JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(S, 0, S.length(), out);
        }
    }

    public static void encodeJavaScriptInXhtmlAttribute(CharSequence S, int start, int end, Appendable out) throws IOException {
        if (S != null) {
            int toPrint = 0;
            for (int c = start; c < end; ++c) {
                String escaped = JavaScriptInXhtmlAttributeEncoder.getEscapedCharacter(S.charAt(c));
                if (escaped != null) {
                    if (toPrint > 0) {
                        out.append(S, c - toPrint, c);
                        toPrint = 0;
                    }
                    out.append(escaped);
                    continue;
                }
                ++toPrint;
            }
            if (toPrint > 0) {
                out.append(S, end - toPrint, end);
            }
        }
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.JAVASCRIPT || inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML_ATTRIBUTE;
    }

    @Override
    public void write(int c, Writer out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute((char)c, (Appendable)out);
    }

    @Override
    public void write(char[] cbuf, Writer out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(cbuf, out);
    }

    @Override
    public void write(char[] cbuf, int off, int len, Writer out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(cbuf, off, len, out);
    }

    @Override
    public void write(String str, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(str, (Appendable)out);
    }

    @Override
    public void write(String str, int off, int len, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(str, off, off + len, (Appendable)out);
    }

    @Override
    public JavaScriptInXhtmlAttributeEncoder append(char c, Appendable out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(c, out);
        return this;
    }

    @Override
    public JavaScriptInXhtmlAttributeEncoder append(CharSequence csq, Appendable out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(csq == null ? "null" : csq, out);
        return this;
    }

    @Override
    public JavaScriptInXhtmlAttributeEncoder append(CharSequence csq, int start, int end, Appendable out) throws IOException {
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(csq == null ? "null" : csq, start, end, out);
        return this;
    }
}

