/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.cms.transform;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.transform.UnmarshallerContext;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class JSONParser {
    public static List<JSONObject> parseJSONArray(UnmarshallerContext context, int length) {
        ArrayList<JSONObject> datapoints = new ArrayList<JSONObject>(length);
        HttpResponse response = context.getHttpResponse();
        try {
            JSONObject json = JSON.parseObject((String)new String(response.getHttpContent(), "UTF-8"));
            if (json == null) {
                return datapoints;
            }
            JSONObject dpjs = json.getJSONObject("Datapoints");
            if (dpjs == null) {
                return datapoints;
            }
            JSONArray array = dpjs.getJSONArray("Datapoint");
            if (array == null) {
                return datapoints;
            }
            for (int i = 0; i < length; ++i) {
                datapoints.add(array.getJSONObject(i));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return datapoints;
    }

    public static List<JSONObject> parseJSONArray(UnmarshallerContext context) {
        try {
            String contont = new String(context.getHttpResponse().getHttpContent(), "UTF-8");
            JSONObject json = JSON.parseObject((String)contont);
            JSONArray array = json.getJSONArray("Datapoints");
            if (array != null) {
                ArrayList<JSONObject> datapoints = new ArrayList<JSONObject>(array.size());
                for (int i = 0; i < array.size(); ++i) {
                    datapoints.add(array.getJSONObject(i));
                }
                return datapoints;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static List<JSONObject> parseJSONArray(UnmarshallerContext context, String arrayKey) {
        try {
            String contont = new String(context.getHttpResponse().getHttpContent(), "UTF-8");
            JSONObject json = JSON.parseObject((String)contont);
            JSONArray array = json.getJSONArray(arrayKey);
            if (array != null) {
                ArrayList<JSONObject> datapoints = new ArrayList<JSONObject>(array.size());
                for (int i = 0; i < array.size(); ++i) {
                    datapoints.add(array.getJSONObject(i));
                }
                return datapoints;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static JSONObject parseJSONObject(UnmarshallerContext context, String key) {
        try {
            String contont = new String(context.getHttpResponse().getHttpContent(), "UTF-8");
            JSONObject json = JSON.parseObject((String)contont);
            JSONObject jsonObject = json.getJSONObject(key);
            return jsonObject;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static <T> T parseResult(UnmarshallerContext context, Class<T> clazz) {
        try {
            String contont = new String(context.getHttpResponse().getHttpContent(), "UTF-8");
            JSONObject json = JSON.parseObject((String)contont);
            return (T)json.getObject("Result", clazz);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static List<String> parseStringArray(UnmarshallerContext context) {
        try {
            String contont = new String(context.getHttpResponse().getHttpContent(), "UTF-8");
            JSONObject json = JSON.parseObject((String)contont);
            JSONArray array = json.getJSONArray("Datapoints");
            if (array != null) {
                ArrayList<String> datapoints = new ArrayList<String>(array.size());
                for (int i = 0; i < array.size(); ++i) {
                    datapoints.add(array.getString(i));
                }
                return datapoints;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }
}

