/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.Grant;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.Permission;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CreateBucketTest
extends TestBase {
    private static final int MAX_BUCKETS_ALLOWED = 10;
    private static final String DEFAULT_LOCATION = "oss-cn-hangzhou";
    private static final String[] ALL_SUPPORTED_LOCATIONS = new String[]{"oss-cn-beijing", "oss-cn-hangzhou", "oss-cn-hongkong", "oss-cn-qingdao", "oss-cn-shenzhen"};

    @Test
    public void testPutWithDefaultLocation() {
        String bucketName = "bucket-with-default-location";
        try {
            try {
                defaultClient.createBucket("bucket-with-default-location");
                String loc = defaultClient.getBucketLocation("bucket-with-default-location");
                Assert.assertEquals((String)DEFAULT_LOCATION, (String)loc);
                defaultClient.createBucket("bucket-with-default-location");
                loc = defaultClient.getBucketLocation("bucket-with-default-location");
                Assert.assertEquals((String)DEFAULT_LOCATION, (String)loc);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                defaultClient.deleteBucket("bucket-with-default-location");
            }
        }
        finally {
            defaultClient.deleteBucket("bucket-with-default-location");
        }
    }

    @Ignore
    public void testPutWithPerferedLocation() {
        String bucketName = "bucket-with-prefered-location";
        CreateBucketRequest request = new CreateBucketRequest("bucket-with-prefered-location");
        OSSClient client = null;
        String[] stringArray = ALL_SUPPORTED_LOCATIONS;
        int n = ALL_SUPPORTED_LOCATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String supportedLoc = stringArray[n2];
                request.setLocationConstraint(supportedLoc);
                client = TestUtils.createClientByLocation(supportedLoc);
                try {
                    try {
                        client.createBucket(request);
                        String loc = client.getBucketLocation("bucket-with-prefered-location");
                        Assert.assertEquals((String)supportedLoc, (String)loc);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                        client.deleteBucket("bucket-with-prefered-location");
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    client.deleteBucket("bucket-with-prefered-location");
                    throw throwable;
                }
                client.deleteBucket("bucket-with-prefered-location");
            }
            ++n2;
        }
    }

    @Test
    public void testPutWithUnsupportedLocation() {
        String bucketName = "bucket-with-unsupported-location";
        String unsupportedLocation = "oss-cn-zhengzhou";
        CreateBucketRequest request = new CreateBucketRequest("bucket-with-unsupported-location");
        request.setLocationConstraint("oss-cn-zhengzhou");
        try {
            defaultClient.createBucket(request);
            Assert.fail((String)"Create bucket should not be successful.");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"InvalidLocationConstraint", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified location-constraint is not valid"));
        }
    }

    @Test
    public void testPutWithInconsistentLocation() {
        String bucketName = "bucket-with-inconsistent-location";
        CreateBucketRequest request = new CreateBucketRequest("bucket-with-inconsistent-location");
        request.setLocationConstraint("oss-cn-shenzhen");
        try {
            defaultClient.createBucket(request);
            Assert.fail((String)"Create bucket should not be successful.");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"InvalidLocationConstraint", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified location-constraint is not valid"));
        }
    }

    @Test
    public void testModifyExistingBucketLocation() {
        String bucketName = "modify-existing-bucket-location";
        try {
            try {
                defaultClient.createBucket("modify-existing-bucket-location");
                String loc = defaultClient.getBucketLocation("modify-existing-bucket-location");
                Assert.assertEquals((String)DEFAULT_LOCATION, (String)loc);
                CreateBucketRequest request = new CreateBucketRequest("modify-existing-bucket-location");
                request.setLocationConstraint("oss-cn-shenzhen");
                defaultClient.createBucket(request);
                Assert.fail((String)"Create bucket should not be successful.");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"InvalidLocationConstraint", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified location-constraint is not valid"));
                defaultClient.deleteBucket("modify-existing-bucket-location");
            }
        }
        finally {
            defaultClient.deleteBucket("modify-existing-bucket-location");
        }
    }

    @Test
    public void testPutExistingBucketWithoutOwnership() {
        String bucketWithoutOwnership = "oss";
        try {
            defaultClient.createBucket("oss");
            Assert.fail((String)"Create bucket should not be successful.");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"BucketAlreadyExists", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again."));
        }
    }

    @Test
    public void testInvalidBucketNames() {
        String[] invalidBucketNames;
        String[] stringArray = invalidBucketNames = new String[]{"ab", "abcdefjhijklmnopqrstuvwxyz0123456789abcdefjhijklmnopqrstuvwxyz-a", "abC", "abc#", "-abc", "#abc", "-abc-", "Abcdefg", "abcdefg-"};
        int n = invalidBucketNames.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String value = stringArray[n2];
                boolean created = false;
                try {
                    try {
                        defaultClient.createBucket(value);
                        created = true;
                        Assert.fail((String)String.format("Invalid bucket name %s should not be created successfully.", value));
                    }
                    catch (Exception ex) {
                        Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
                        if (created) {
                            defaultClient.deleteBucket(value);
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (created) {
                        defaultClient.deleteBucket(value);
                    }
                    throw throwable;
                }
                if (created) {
                    defaultClient.deleteBucket(value);
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Ignore
    public void testPutTooManyBuckets() {
        block20: {
            bucketNamePrefix = "too-many-buckets-";
            try {
                block19: {
                    existingBuckets = new ArrayList<String>();
                    bucketListing = CreateBucketTest.defaultClient.listBuckets();
                    for (Bucket bkt : bucketListing) {
                        existingBuckets.add(bkt.getName());
                    }
                    remaindingAllowed = 10 - existingBuckets.size();
                    newlyBuckets = new ArrayList<String>();
                    i = 0;
                    while (i < remaindingAllowed) {
                        bucketName = "too-many-buckets-" + i;
                        try {
                            CreateBucketTest.defaultClient.createBucket(bucketName);
                            newlyBuckets.add(bucketName);
                            ++i;
                            loc = CreateBucketTest.defaultClient.getBucketLocation(bucketName);
                            Assert.assertEquals((String)"oss-cn-hangzhou", (String)loc);
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                    try {
                        try {
                            CreateBucketTest.defaultClient.createBucket("too-many-buckets-10");
                            Assert.fail((String)"Create bucket should not be successful.");
                            break block19;
                        }
                        catch (OSSException oe) {
                            Assert.assertEquals((String)"TooManyBuckets", (String)oe.getErrorCode());
                            Assert.assertTrue((boolean)oe.getMessage().startsWith("You have attempted to create more buckets than allowed."));
                            ** for (bkt : newlyBuckets)
                        }
                    }
                    catch (Throwable var8_13) {
                        ** for (bkt : newlyBuckets)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            CreateBucketTest.defaultClient.deleteBucket(bkt);
                        }
                        catch (Exception var11_20) {
                            // empty catch block
                        }
                        continue;
lbl43:
                        // 1 sources

                        break block20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            CreateBucketTest.defaultClient.deleteBucket(bkt);
                        }
                        catch (Exception var11_21) {
                            // empty catch block
                        }
                        continue;
                    }
lbl52:
                    // 1 sources

                    throw var8_13;
                }
                for (String bkt : newlyBuckets) {
                    try {
                        CreateBucketTest.defaultClient.deleteBucket(bkt);
                    }
                    catch (Exception var11_22) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void testPutWithCannedACL() {
        String bucketName = "bucket-with-canned-acl";
        CreateBucketRequest createBucketRequest = new CreateBucketRequest("bucket-with-canned-acl");
        try {
            try {
                secondClient.createBucket(createBucketRequest);
                AccessControlList returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                Set<Grant> grants = returnedAcl.getGrants();
                Assert.assertEquals((int)0, (int)grants.size());
                secondClient.createBucket("bucket-with-canned-acl");
                TestUtils.waitForCacheExpiration(5);
                returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                grants = returnedAcl.getGrants();
                Assert.assertEquals((int)0, (int)grants.size());
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                secondClient.createBucket(createBucketRequest);
                returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                grants = returnedAcl.getGrants();
                Assert.assertEquals((int)1, (int)grants.size());
                Grant grant = (Grant)grants.toArray()[0];
                Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                Assert.assertEquals((Object)((Object)Permission.Read), (Object)((Object)grant.getPermission()));
                secondClient.createBucket("bucket-with-canned-acl");
                TestUtils.waitForCacheExpiration(5);
                returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                grants = returnedAcl.getGrants();
                Assert.assertEquals((int)1, (int)grants.size());
                grant = (Grant)grants.toArray()[0];
                Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                Assert.assertEquals((Object)((Object)Permission.Read), (Object)((Object)grant.getPermission()));
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicReadWrite);
                secondClient.createBucket(createBucketRequest);
                TestUtils.waitForCacheExpiration(5);
                returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                grants = returnedAcl.getGrants();
                Assert.assertEquals((int)1, (int)grants.size());
                grant = (Grant)grants.toArray()[0];
                Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                Assert.assertEquals((Object)((Object)Permission.FullControl), (Object)((Object)grant.getPermission()));
                secondClient.createBucket("bucket-with-canned-acl");
                TestUtils.waitForCacheExpiration(5);
                returnedAcl = secondClient.getBucketAcl("bucket-with-canned-acl");
                grants = returnedAcl.getGrants();
                Assert.assertEquals((int)1, (int)grants.size());
                grant = (Grant)grants.toArray()[0];
                Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                Assert.assertEquals((Object)((Object)Permission.FullControl), (Object)((Object)grant.getPermission()));
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                secondClient.deleteBucket("bucket-with-canned-acl");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-with-canned-acl");
        }
    }
}

