/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapSerializer
implements ObjectSerializer {
    public static MapSerializer instance = new MapSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        TreeMap map = (TreeMap)object;
        if (out.isEnabled(SerializerFeature.SortField) && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            try {
                map = new TreeMap(map);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (serializer.containsReference(object)) {
            serializer.writeReference(object);
            return;
        }
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName);
        try {
            out.write('{');
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            boolean first = true;
            if (out.isEnabled(SerializerFeature.WriteClassName)) {
                out.writeFieldName("@type");
                out.writeString(object.getClass().getName());
                first = false;
            }
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                Object entryKey = entry.getKey();
                if (entryKey == null || entryKey instanceof String) {
                    List<ValueFilter> valueFilters;
                    List<NameFilter> nameFilters;
                    String key = (String)entryKey;
                    List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
                    if (propertyFilters != null) {
                        boolean apply = true;
                        for (PropertyFilter propertyFilter : propertyFilters) {
                            if (propertyFilter.apply(object, key, value)) continue;
                            apply = false;
                            break;
                        }
                        if (!apply) continue;
                    }
                    if ((nameFilters = serializer.getNameFiltersDirect()) != null) {
                        for (NameFilter nameFilter : nameFilters) {
                            key = nameFilter.process(object, key, value);
                        }
                    }
                    if ((valueFilters = serializer.getValueFiltersDirect()) != null) {
                        for (ValueFilter valueFilter : valueFilters) {
                            value = valueFilter.process(object, key, value);
                        }
                    }
                    if (value == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                    if (!first) {
                        out.write(',');
                    }
                    out.writeFieldName(key, true);
                } else {
                    if (!first) {
                        out.write(',');
                    }
                    serializer.write(entryKey);
                    out.write(':');
                }
                first = false;
                if (value == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = value.getClass();
                if (clazz == preClazz) {
                    preWriter.write(serializer, value, entryKey, null);
                    continue;
                }
                preClazz = clazz;
                preWriter = serializer.getObjectWriter(clazz);
                preWriter.write(serializer, value, entryKey, null);
            }
        }
        finally {
            serializer.setContext(parent);
        }
        out.write('}');
    }
}

