/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.tablebind;

import cn.dreampie.ClassSearchKit;
import cn.dreampie.tablebind.INameStyle;
import cn.dreampie.tablebind.SimpleNameStyles;
import cn.dreampie.tablebind.TableBind;
import com.google.common.collect.Lists;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Logger;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBindPlugin
extends ActiveRecordPlugin {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<Class<? extends Model>> excludeClasses = Lists.newArrayList();
    private List<Class<? extends Model>> includeClasses = Lists.newArrayList();
    private List<String> includeClassPaths = Lists.newArrayList();
    private List<String> excludeClassPaths = Lists.newArrayList();
    private boolean autoScan = false;
    private INameStyle nameStyle;

    public TableBindPlugin(DataSource dataSource) {
        this(dataSource, SimpleNameStyles.DEFAULT);
    }

    public TableBindPlugin(DataSource dataSource, INameStyle nameStyle) {
        super(dataSource);
        this.nameStyle = nameStyle;
    }

    public TableBindPlugin(IDataSourceProvider dataSourceProvider) {
        this(dataSourceProvider, SimpleNameStyles.DEFAULT);
    }

    public TableBindPlugin(IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public TableBindPlugin(String dataSourceName, IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(dataSourceName, dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public TableBindPlugin addExcludeClasses(Class<? extends Model> ... clazzes) {
        for (Class<? extends Model> clazz : clazzes) {
            this.excludeClasses.add(clazz);
        }
        return this;
    }

    public TableBindPlugin addExcludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.excludeClasses.addAll(clazzes);
        }
        return this;
    }

    public TableBindPlugin addExcludePaths(String ... paths) {
        for (String path : paths) {
            this.excludeClassPaths.add(path);
        }
        return this;
    }

    public TableBindPlugin addIncludeClasses(Class<? extends Model> ... clazzes) {
        for (Class<? extends Model> clazz : clazzes) {
            this.includeClasses.add(clazz);
        }
        return this;
    }

    public TableBindPlugin addIncludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.includeClasses.addAll(clazzes);
        }
        return this;
    }

    public TableBindPlugin addIncludePaths(String ... paths) {
        for (String path : paths) {
            this.includeClassPaths.add(path);
        }
        return this;
    }

    public boolean start() {
        if (this.includeClasses.size() <= 0) {
            this.includeClasses = ClassSearchKit.of(Model.class).includepaths(this.includeClassPaths).search();
        }
        TableBind tb = null;
        for (Class<? extends Model> modelClass : this.includeClasses) {
            String tableName;
            boolean isexclude = false;
            if (this.excludeClassPaths.size() > 0) {
                for (String excludepath : this.excludeClassPaths) {
                    if (!modelClass.getName().startsWith(excludepath)) continue;
                    this.log.debug("exclude model:" + modelClass.getName());
                    isexclude = true;
                    break;
                }
            }
            if (isexclude || this.excludeClasses.contains(modelClass)) continue;
            tb = modelClass.getAnnotation(TableBind.class);
            if (tb == null) {
                if (!this.autoScan) continue;
                tableName = this.nameStyle.name(modelClass.getSimpleName());
                this.addMapping(tableName, modelClass);
                this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
                continue;
            }
            tableName = tb.tableName();
            if (StrKit.notBlank((String)tb.pkName())) {
                this.addMapping(tableName, tb.pkName(), modelClass);
                this.log.debug("addMapping(" + tableName + ", " + tb.pkName() + "," + modelClass.getName() + ")");
                continue;
            }
            this.addMapping(tableName, modelClass);
            this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
        }
        return super.start();
    }

    public boolean stop() {
        return super.stop();
    }

    public TableBindPlugin autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }
}

