/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.utils;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private long startTime;
    private long stopTime;
    private State state;
    private boolean split;

    public StopWatch() {
        this.reset();
    }

    public long getNanoTime() {
        switch (this.state) {
            case RUNNING: {
                return System.nanoTime() - this.startTime;
            }
            case STOPPED: 
            case SUSPENDED: {
                return this.stopTime - this.startTime;
            }
            case UNSTARTED: {
                return 0L;
            }
        }
        throw new RuntimeException("Should never get here.");
    }

    public long getNanoTimeFromSplit() {
        if (this.state == State.RUNNING && this.split) {
            return System.nanoTime() - this.stopTime;
        }
        throw new RuntimeException("Stopwatch must be running and split to get the time from split.");
    }

    public long getSplitNanoTime() {
        if (this.split) {
            return this.stopTime - this.startTime;
        }
        throw new RuntimeException("Stopwatch must be running and split to get the split time.");
    }

    public long getSplitTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.getSplitNanoTime());
    }

    public long getTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.getNanoTime());
    }

    public long getTimeFromSplit() {
        return TimeUnit.NANOSECONDS.toMillis(this.getNanoTimeFromSplit());
    }

    public void reset() {
        this.state = State.UNSTARTED;
        this.split = false;
    }

    public void resume() {
        if (this.state == State.SUSPENDED) {
            this.startTime += System.nanoTime() - this.stopTime;
            this.state = State.RUNNING;
            return;
        }
        throw new RuntimeException("Stopwatch must be suspended to resume.");
    }

    public void split() {
        if (this.state == State.RUNNING) {
            this.stopTime = System.nanoTime();
            this.split = true;
            return;
        }
        throw new RuntimeException("Stopwatch is not running.");
    }

    public void start() {
        if (this.state == State.UNSTARTED) {
            this.startTime = System.nanoTime();
            this.state = State.RUNNING;
            return;
        }
        throw new RuntimeException("Stopwatch already started or stopped.");
    }

    public void stop() {
        switch (this.state) {
            case RUNNING: {
                this.stopTime = System.nanoTime();
            }
            case SUSPENDED: {
                this.state = State.STOPPED;
                this.split = false;
                return;
            }
        }
        throw new RuntimeException("Stopwatch is not running.");
    }

    public void suspend() {
        if (this.state == State.RUNNING) {
            this.stopTime = System.nanoTime();
            this.state = State.SUSPENDED;
            return;
        }
        throw new RuntimeException("Stopwatch must be running to suspend.");
    }

    static enum State {
        UNSTARTED,
        RUNNING,
        STOPPED,
        SUSPENDED;

    }
}

