/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class FileUtils {
    private static final Log log = Logs.get();

    public static boolean cleanSvn(File dir) {
        try {
            Files.cleanAllFolderInSubFolderes((File)dir, (String)".svn");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static long countJAVACodeLines(File file) {
        return FileUtils.countLines(file, ".java");
    }

    public static void main(String[] args) {
        FileUtils.cleanSvn(new File("H:\\\u4ee3\u7801\u5907\u4efd"));
        System.err.println("\u4ee3\u7801\u5907\u4efd\u76ee\u5f55\u5927\u5c0f:" + FileUtils.formetFileSize(FileUtils.getDirSize(new File("H:\\\u4ee3\u7801\u5907\u4efd"))));
        System.err.println("JAVA\u4ee3\u7801\u884c\u6570:" + FileUtils.countJAVACodeLines(new File("H:\\\u4ee3\u7801\u5907\u4efd")));
        System.err.println("HTML\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".html"));
        System.err.println("js\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".js"));
        System.err.println("XML\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".xml"));
        System.err.println("OC\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".m"));
        System.err.println("VM\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".vm"));
        System.err.println("SQL\u914d\u7f6e\u4ee3\u7801\u884c\u6570:" + FileUtils.countLines(new File("H:\\\u4ee3\u7801\u5907\u4efd"), ".properties"));
    }

    public static double getDirSize(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                double size = 0.0;
                for (File f : children) {
                    size += FileUtils.getDirSize(f);
                }
                return size;
            }
            double size = file.length();
            return size;
        }
        return 0.0;
    }

    public static String formetFileSize(double length) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = length < 1024.0 ? df.format(length) + "B" : (length < 1048576.0 ? df.format(length / 1024.0) + "K" : (length < 1.073741824E9 ? df.format(length / 1048576.0) + "M" : df.format(length / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countLine(File file) {
        long target = 0L;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            if (reader != null) {
                while (reader.readLine() != null) {
                    ++target;
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
        return target;
    }

    public static long countLines(File file, String suf) {
        long target = 0L;
        if (file.isFile() && file.getName().endsWith(suf)) {
            return FileUtils.countLine(file);
        }
        if (file.isFile()) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                target += FileUtils.countLines(f, suf);
            }
        }
        return target;
    }

    public static File fastFindFile(File dir, String name) {
        return FileUtils.fastFindFile(dir, name, 1);
    }

    public static File fastFindFile(File dir, String name, int method) {
        File target = null;
        File[] dirs = Files.dirs((File)dir);
        File[] files = Files.files((File)dir, (String)name);
        if (files != null) {
            for (File file : files) {
                if (!(method == 1 ? Strings.equals((String)file.getName(), (String)name) : (method == 2 ? file.getName().endsWith(name) : (method == 3 ? Strings.equals((String)file.getName().toUpperCase(), (String)name.toUpperCase()) : file.getName().toUpperCase().endsWith(name.toUpperCase()))))) continue;
                return file;
            }
        }
        if (dirs != null) {
            for (File file : dirs) {
                target = FileUtils.findFile(file, name);
                if (target == null) continue;
                return target;
            }
        }
        return target;
    }

    public static File fastFindFile(String dir, String name) {
        return FileUtils.fastFindFile(new File(dir), name, 1);
    }

    public static File fastFindFileLikeName(File dir, String name) {
        return FileUtils.fastFindFile(dir, name, 2);
    }

    public static File findFile(File dir, String name) {
        File target = null;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && Strings.equals((String)file.getName(), (String)name)) {
                    return file;
                }
                if (!file.isDirectory() || (target = FileUtils.findFile(file, name)) == null) continue;
                return target;
            }
        }
        return target;
    }
}

