/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.utils;

import club.zhcs.utils.StopWatch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;

public class Downloader
implements Callable<File> {
    protected int connectTimeout = 30000;
    protected int readTimeout = 1000000;
    protected int speedRefreshInterval = 500;
    protected byte[] buffer = new byte[8192];
    private URL url;
    private File file;
    private float averageSpeed;
    private float currentSpeed;

    private static File autoRenameIfExist(File file) {
        if (file.exists()) {
            String path = file.getAbsolutePath();
            String extension = Downloader.getExtension(path);
            int baseLength = path.length();
            if (extension.length() > 0) {
                baseLength = path.length() - extension.length() - 1;
            }
            StringBuilder buffer = new StringBuilder(path);
            for (int index = 1; index < Integer.MAX_VALUE; ++index) {
                buffer.setLength(baseLength);
                buffer.append('(').append(index).append(')');
                if (extension.length() > 0) {
                    buffer.append('.').append(extension);
                }
                if (!(file = new File(buffer.toString())).exists()) break;
            }
        }
        return file;
    }

    private static String getExtension(String string) {
        int lastDotIndex = string.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return string.substring(lastDotIndex + 1);
        }
        return "";
    }

    private static float getSpeed(long bytesInTime, long time) {
        return (float)bytesInTime / 1024.0f / ((float)time / 1000.0f);
    }

    @Override
    public File call() throws Exception {
        StopWatch watch = new StopWatch();
        watch.start();
        InputStream in = null;
        OutputStream out = null;
        try {
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            conn.connect();
            in = conn.getInputStream();
            out = new FileOutputStream(this.file);
            int time = 0;
            int bytesInTime = 0;
            while (true) {
                watch.split();
                int bytes = in.read(this.buffer);
                if (bytes == -1) {
                    break;
                }
                out.write(this.buffer, 0, bytes);
                if ((time = (int)((long)time + watch.getTimeFromSplit())) < this.speedRefreshInterval) continue;
                this.currentSpeed = Downloader.getSpeed(bytesInTime, time);
                time = 0;
                bytesInTime = 0;
            }
        }
        catch (IOException e) {
            this.file.delete();
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        watch.stop();
        this.averageSpeed = Downloader.getSpeed(this.file.length(), watch.getTime());
        return this.file;
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public float getCurrentSpeed() {
        return this.currentSpeed;
    }

    public File getFile() {
        return this.file;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrlAndFile(URL url, File file) {
        this.url = url;
        this.file = Downloader.autoRenameIfExist(file);
        this.averageSpeed = 0.0f;
        this.currentSpeed = 0.0f;
    }
}

