/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.sender.GelfTCPSender;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class GelfTCPSSLSender
extends GelfTCPSender {
    private final SSLContext sslContext;
    private final ThreadLocal<ByteBuffer> sslNetworkBuffers = new ThreadLocal();
    private final ThreadLocal<ByteBuffer> tempBuffers = new ThreadLocal();
    private volatile SSLEngine sslEngine;
    private volatile SSLSession sslSession;

    public GelfTCPSSLSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, int deliveryAttempts, boolean keepAlive, ErrorReporter errorReporter, SSLContext sslContext) throws IOException {
        super(host, port, connectTimeoutMs, readTimeoutMs, deliveryAttempts, keepAlive, errorReporter);
        this.sslContext = sslContext;
    }

    @Override
    protected boolean connect() throws IOException {
        this.sslEngine = this.sslContext.createSSLEngine();
        this.sslEngine.setUseClientMode(true);
        this.sslSession = this.sslEngine.getSession();
        if (super.connect()) {
            this.sslEngine.beginHandshake();
            this.doHandshake((SocketChannel)this.channel(), this.sslEngine, ByteBuffer.allocate(this.sslSession.getPacketBufferSize()), ByteBuffer.allocate(this.sslSession.getPacketBufferSize()));
        }
        return false;
    }

    @Override
    protected boolean isConnected() throws IOException {
        return this.channel() != null && ((SocketChannel)this.channel()).isOpen() && this.isConnected((SocketChannel)this.channel());
    }

    @Override
    protected void write(ByteBuffer gelfBuffer) throws IOException {
        while (gelfBuffer.hasRemaining()) {
            this.read();
            ByteBuffer myNetData = this.getNetworkBuffer();
            gelfBuffer.mark();
            SSLEngineResult res = this.sslEngine.wrap(gelfBuffer, myNetData);
            if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.sslNetworkBuffers.set(this.enlargeBuffer(gelfBuffer, myNetData));
                gelfBuffer.reset();
            }
            if (res.getStatus() != SSLEngineResult.Status.OK) continue;
            myNetData.flip();
            while (myNetData.hasRemaining()) {
                int written = ((SocketChannel)this.channel()).write(myNetData);
                if (written != -1) continue;
                throw new SocketException("Channel closed");
            }
        }
    }

    private void read() throws IOException {
        ByteBuffer myNetData = this.getNetworkBuffer();
        ByteBuffer tempBuffer = this.getTempBuffer();
        if (((SocketChannel)this.channel()).read(myNetData) < 0) {
            throw new SocketException("Channel closed");
        }
        myNetData.flip();
        this.sslEngine.unwrap(myNetData, tempBuffer);
    }

    private ByteBuffer getNetworkBuffer() {
        ByteBuffer networkBuffer = this.sslNetworkBuffers.get();
        if (networkBuffer == null) {
            networkBuffer = ByteBuffer.allocateDirect(this.sslSession.getPacketBufferSize());
            this.sslNetworkBuffers.set(networkBuffer);
        }
        networkBuffer.clear();
        return networkBuffer;
    }

    private ByteBuffer getTempBuffer() {
        ByteBuffer tempBuffer = this.tempBuffers.get();
        if (tempBuffer == null) {
            tempBuffer = ByteBuffer.allocateDirect(this.sslSession.getApplicationBufferSize());
            this.tempBuffers.set(tempBuffer);
        }
        tempBuffer.clear();
        return tempBuffer;
    }

    private ByteBuffer enlargeBuffer(ByteBuffer src, ByteBuffer dst) {
        ByteBuffer buffer = ByteBuffer.allocate(dst.capacity() + src.remaining());
        dst.flip();
        buffer.put(dst);
        return buffer;
    }

    private void doHandshake(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer myNetData, ByteBuffer peerNetData) throws IOException {
        int appBufferSize = sslEngine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        SSLEngineResult.HandshakeStatus hs = sslEngine.getHandshakeStatus();
        while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            block0 : switch (hs) {
                case NEED_UNWRAP: {
                    if (socketChannel.read(peerNetData) < 0) {
                        throw new SocketException("Channel closed");
                    }
                    peerNetData.flip();
                    SSLEngineResult res = sslEngine.unwrap(peerNetData, peerAppData);
                    peerNetData.compact();
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            break block0;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = this.enlargeBuffer(peerNetData, peerAppData);
                            break block0;
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    myNetData.clear();
                    SSLEngineResult res = sslEngine.wrap(myAppData, myNetData);
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                if (socketChannel.write(myNetData) >= 0) continue;
                            }
                            break block0;
                        }
                        case BUFFER_OVERFLOW: {
                            myNetData = this.enlargeBuffer(myAppData, myNetData);
                            break block0;
                        }
                        case BUFFER_UNDERFLOW: {
                            break block0;
                        }
                        case CLOSED: {
                            if (sslEngine.isOutboundDone()) {
                                return;
                            }
                            sslEngine.closeOutbound();
                            hs = sslEngine.getHandshakeStatus();
                            break block0;
                        }
                    }
                    throw new IOException("Cannot wrap data: " + (Object)((Object)res.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    hs = sslEngine.getHandshakeStatus();
                    break;
                }
                case FINISHED: {
                    return;
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.channel() != null) {
            try {
                this.closeSocketChannel();
            }
            catch (IOException e) {
                this.reportError(e.getMessage(), e);
            }
        }
        super.close();
    }

    private void closeSocketChannel() throws IOException {
        this.sslEngine.closeOutbound();
        this.doHandshake((SocketChannel)this.channel(), this.sslEngine, ByteBuffer.allocate(this.sslSession.getPacketBufferSize()), ByteBuffer.allocate(this.sslSession.getPacketBufferSize()));
    }
}

