/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.CglibProxyFactory;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationProvider;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class JavaImplementationProviderFactory
implements ImplementationProviderFactory<JavaImplementation> {
    private static final Logger logger = Logger.getLogger(JavaImplementationProviderFactory.class.getName());
    private PropertyValueFactory propertyValueFactory;
    private DataBindingExtensionPoint databindings;
    private ProxyFactory proxyFactory;
    private ComponentContextFactory componentContextFactory;
    private RequestContextFactory requestContextFactory;

    public JavaImplementationProviderFactory(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        MessageFactory messageFactory = (MessageFactory)factories.getFactory(MessageFactory.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        InterfaceContractMapper interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        ProxyFactoryExtensionPoint proxyFactories = (ProxyFactoryExtensionPoint)registry.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        try {
            proxyFactories.setClassProxyFactory((ProxyFactory)new CglibProxyFactory(messageFactory, interfaceContractMapper));
        }
        catch (NoClassDefFoundError e) {
            logger.log(Level.WARNING, "Class-based proxy is not supported", e);
        }
        this.databindings = (DataBindingExtensionPoint)registry.getExtensionPoint(DataBindingExtensionPoint.class);
        this.propertyValueFactory = (PropertyValueFactory)factories.getFactory(PropertyValueFactory.class);
        ContextFactoryExtensionPoint contextFactories = (ContextFactoryExtensionPoint)registry.getExtensionPoint(ContextFactoryExtensionPoint.class);
        this.componentContextFactory = (ComponentContextFactory)contextFactories.getFactory(ComponentContextFactory.class);
        this.requestContextFactory = (RequestContextFactory)contextFactories.getFactory(RequestContextFactory.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance((ExtensionPointRegistry)registry);
    }

    public ImplementationProvider createImplementationProvider(RuntimeComponent component, JavaImplementation implementation) {
        return new JavaImplementationProvider(component, implementation, this.proxyFactory, this.databindings, this.propertyValueFactory, this.componentContextFactory, this.requestContextFactory);
    }

    public Class<JavaImplementation> getModelType() {
        return JavaImplementation.class;
    }
}

