/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.factory.InstanceWrapper;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallableReferenceObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallbackWireObjectFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.WireObjectFactory;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.JavaScopeImpl;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.invocation.JavaAsyncImplementationInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.JavaInstanceFactoryProvider;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceReference;

public class JavaComponentContextProvider {
    private JavaPropertyValueObjectFactory propertyValueFactory;
    private RuntimeComponent component;
    private JavaInstanceFactoryProvider<?> instanceFactoryProvider;
    private ProxyFactory proxyFactory;
    private InstanceFactory instanceFactory;
    private JavaScopeImpl scope;

    public JavaComponentContextProvider(RuntimeComponent component, JavaInstanceFactoryProvider configuration, DataBindingExtensionPoint dataBindingExtensionPoint, PropertyValueFactory propertyValueObjectFactory, ComponentContextFactory componentContextFactory, RequestContextFactory requestContextFactory) {
        this.instanceFactoryProvider = configuration;
        this.proxyFactory = configuration.getProxyFactory();
        this.component = component;
        this.propertyValueFactory = (JavaPropertyValueObjectFactory)propertyValueObjectFactory;
        this.scope = ((JavaImplementation)component.getImplementation()).getJavaScope();
    }

    InstanceWrapper<?> createInstanceWrapper() throws ObjectCreationException {
        if (this.instanceFactory == null) {
            this.start();
        }
        return this.instanceFactory.newInstance();
    }

    void configureProperties(List<ComponentProperty> definedProperties) {
        for (ComponentProperty p : definedProperties) {
            this.configureProperty(p);
        }
    }

    private void configureProperty(ComponentProperty configuredProperty) {
        JavaElementImpl element = (JavaElementImpl)this.instanceFactoryProvider.getImplementation().getPropertyMembers().get(configuredProperty.getName());
        if (element != null && configuredProperty.getValue() != null) {
            if (!(element.getAnchor() instanceof Constructor)) {
                if (element.getElementType() == ElementType.FIELD) {
                    this.instanceFactoryProvider.getInjectionSites().add(element);
                } else {
                    this.instanceFactoryProvider.getInjectionSites().add(element);
                }
            }
            ObjectFactory<?> propertyObjectFactory = this.createPropertyValueFactory(configuredProperty, configuredProperty.getValue(), element);
            this.instanceFactoryProvider.setObjectFactory(element, propertyObjectFactory);
            JavaConstructorImpl constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
            for (JavaParameterImpl p : constructor.getParameters()) {
                if (!element.getName().equals(p.getName())) continue;
                this.instanceFactoryProvider.setObjectFactory((JavaElementImpl)p, propertyObjectFactory);
            }
        }
    }

    void start() {
        Class businessInterface;
        List<JavaElementImpl> callbackInjectionList = null;
        callbackInjectionList = this.scope.equals((Object)JavaScopeImpl.STATELESS) ? this.instanceFactoryProvider.getCallbackInjectionSites() : this.instanceFactoryProvider.getInjectionSites();
        if (!this.instanceFactoryProvider.getImplementation().getCallbackMembers().isEmpty()) {
            HashMap<String, List> callbackWires = new HashMap<String, List>();
            for (ComponentService componentService : this.component.getServices()) {
                List wires;
                RuntimeComponentReference callbackReference = (RuntimeComponentReference)componentService.getCallbackReference();
                if (callbackReference == null || (wires = callbackReference.getEndpointReferences()).isEmpty()) continue;
                RuntimeEndpointReference epr = (RuntimeEndpointReference)wires.get(0);
                callbackWires.put(epr.getComponentTypeReferenceInterfaceContract().getInterface().toString(), wires);
            }
            for (Map.Entry entry : this.instanceFactoryProvider.getImplementation().getCallbackMembers().entrySet()) {
                List wires = (List)callbackWires.get(entry.getKey());
                if (wires == null) continue;
                for (JavaElementImpl element : (Collection)entry.getValue()) {
                    businessInterface = element.getType();
                    CallbackWireObjectFactory factory = null;
                    if (ServiceReference.class.isAssignableFrom(element.getType())) {
                        businessInterface = JavaIntrospectionHelper.getBusinessInterface((Class)element.getType(), (Type)element.getGenericType());
                        factory = new CallbackReferenceObjectFactory(businessInterface, this.proxyFactory, wires);
                    } else {
                        factory = new CallbackWireObjectFactory(businessInterface, this.proxyFactory, wires);
                    }
                    if (!(element.getAnchor() instanceof Constructor)) {
                        callbackInjectionList.add(element);
                    }
                    this.instanceFactoryProvider.setObjectFactory(element, (ObjectFactory<?>)factory);
                }
            }
        }
        for (Reference ref : this.instanceFactoryProvider.getImplementation().getReferences()) {
            JavaElementImpl javaElementImpl = (JavaElementImpl)this.instanceFactoryProvider.getImplementation().getReferenceMembers().get(ref.getName());
            if (javaElementImpl == null) continue;
            if (!(javaElementImpl.getAnchor() instanceof Constructor)) {
                if (javaElementImpl.getElementType() == ElementType.FIELD) {
                    Field field = (Field)javaElementImpl.getAnchor();
                    if (Modifier.isPublic(field.getModifiers())) {
                        this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                    } else if (field.getAnnotation(org.oasisopen.sca.annotation.Reference.class) != null) {
                        this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                    }
                } else {
                    this.instanceFactoryProvider.getInjectionSites().add(javaElementImpl);
                }
            }
            ComponentReference componentReference = null;
            List wireList = null;
            for (ComponentReference reference : this.component.getReferences()) {
                if (!reference.getName().equals(ref.getName())) continue;
                wireList = ((RuntimeComponentReference)reference).getEndpointReferences();
                componentReference = reference;
                break;
            }
            if (ref.getMultiplicity() == Multiplicity.ONE_N || ref.getMultiplicity() == Multiplicity.ZERO_N) {
                ArrayList factories = new ArrayList();
                Class baseType = JavaIntrospectionHelper.getBaseType((Class)javaElementImpl.getType(), (Type)javaElementImpl.getGenericType());
                for (int i = 0; i < wireList.size(); ++i) {
                    CallableReferenceObjectFactory factory = null;
                    if (ServiceReference.class.isAssignableFrom(baseType)) {
                        Type callableRefType = JavaIntrospectionHelper.getParameterType((Type)javaElementImpl.getGenericType());
                        Class businessInterface2 = JavaIntrospectionHelper.getBusinessInterface((Class)baseType, (Type)callableRefType);
                        factory = new CallableReferenceObjectFactory(businessInterface2, (RuntimeEndpointReference)wireList.get(i));
                    } else {
                        factory = this.createObjectFactory(baseType, (EndpointReference)wireList.get(i));
                    }
                    factories.add((ObjectFactory<?>)factory);
                }
                this.instanceFactoryProvider.setObjectFactories(javaElementImpl, factories);
                JavaConstructorImpl constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
                for (JavaParameterImpl p : constructor.getParameters()) {
                    if (!javaElementImpl.getName().equals(p.getName())) continue;
                    this.instanceFactoryProvider.setObjectFactories((JavaElementImpl)p, factories);
                }
                continue;
            }
            if (wireList == null && ref.getMultiplicity() == Multiplicity.ONE_ONE) {
                throw new IllegalStateException("Required reference is missing: " + ref.getName());
            }
            if (wireList == null || wireList.isEmpty()) continue;
            CallableReferenceObjectFactory factory = null;
            if (ServiceReference.class.isAssignableFrom(javaElementImpl.getType())) {
                businessInterface = JavaIntrospectionHelper.getBusinessInterface((Class)javaElementImpl.getType(), (Type)javaElementImpl.getGenericType());
                factory = new CallableReferenceObjectFactory(businessInterface, (RuntimeEndpointReference)wireList.get(0));
            } else {
                factory = this.createObjectFactory(javaElementImpl.getType(), (EndpointReference)wireList.get(0));
            }
            this.instanceFactoryProvider.setObjectFactory(javaElementImpl, (ObjectFactory<?>)factory);
            JavaConstructorImpl constructor = this.instanceFactoryProvider.getImplementation().getConstructor();
            for (JavaParameterImpl p : constructor.getParameters()) {
                if (!javaElementImpl.getName().equals(p.getName())) continue;
                this.instanceFactoryProvider.setObjectFactory((JavaElementImpl)p, (ObjectFactory<?>)factory);
            }
        }
        this.instanceFactory = this.instanceFactoryProvider.createFactory();
    }

    void addResourceFactory(String name, ObjectFactory<?> factory) {
        JavaResourceImpl resource = (JavaResourceImpl)this.instanceFactoryProvider.getImplementation().getResources().get(name);
        if (resource != null && !(resource.getElement().getAnchor() instanceof Constructor)) {
            this.instanceFactoryProvider.getInjectionSites().add(resource.getElement());
        }
        this.instanceFactoryProvider.setObjectFactory(resource.getElement(), factory);
    }

    Object createInstance() throws ObjectCreationException {
        return this.createInstanceWrapper().getInstance();
    }

    JavaInstanceFactoryProvider<?> getInstanceFactoryProvider() {
        return this.instanceFactoryProvider;
    }

    void stop() {
    }

    Invoker createInvoker(Operation operation, RuntimeComponentService service) throws NoSuchMethodException {
        Class<?> implClass = this.instanceFactoryProvider.getImplementationClass();
        Method method = JavaInterfaceUtil.findMethod(implClass, (Operation)operation);
        if (operation instanceof JavaOperation && ((JavaOperation)operation).isAsyncServer()) {
            return new JavaAsyncImplementationInvoker(operation, method, this.component, service);
        }
        return new JavaImplementationInvoker(operation, method, this.component, service);
    }

    private <B> ObjectFactory<B> createObjectFactory(Class<B> interfaze, EndpointReference wire) {
        return new WireObjectFactory(interfaze, (Invocable)((RuntimeEndpointReference)wire), this.proxyFactory);
    }

    private ObjectFactory<?> createPropertyValueFactory(ComponentProperty property, Object propertyValue, JavaElementImpl javaElement) {
        return this.propertyValueFactory.createValueFactory((Property)property, propertyValue, javaElement);
    }

    RuntimeComponent getComponent() {
        return this.component;
    }

    private static class OptimizedObjectFactory<T>
    implements ObjectFactory<T> {
        private ScopeContainer scopeContainer;

        public OptimizedObjectFactory(ScopeContainer scopeContainer) {
            this.scopeContainer = scopeContainer;
        }

        public T getInstance() throws ObjectCreationException {
            try {
                return (T)this.scopeContainer.getWrapper(null).getInstance();
            }
            catch (TargetResolutionException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
    }
}

