/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tuscany.sca.core.invocation.AsyncFaultWrapper;
import org.apache.tuscany.sca.core.invocation.AsyncResponseHandler;
import org.apache.tuscany.sca.core.invocation.JDKAsyncResponseInvoker;
import org.apache.tuscany.sca.invocation.Message;
import org.oasisopen.sca.ServiceRuntimeException;

public class JavaAsyncResponseInvokerImpl
implements JDKAsyncResponseInvoker {
    private ConcurrentMap<String, Object> asyncMessageMap = new ConcurrentHashMap<String, Object>();

    public void invokeAsyncResponse(Message msg) {
        String relatesID = this.getMessageRelatesID(msg);
        if (relatesID == null) {
            throw new ServiceRuntimeException("JavaAsyncResponseInvoker - response message has no RELATES_TO id");
        }
        Object responseHandler = this.asyncMessageMap.remove(relatesID);
        if (responseHandler == null) {
            throw new ServiceRuntimeException("JavaAsyncResponseInvoker - no Future matches the RELATES_TO id: " + relatesID);
        }
        AsyncResponseHandler future = (AsyncResponseHandler)responseHandler;
        Object payload = msg.getBody();
        if (payload == null) {
            System.out.println("Returned response message was null");
        } else {
            Object response = payload.getClass().isArray() ? ((Object[])payload)[0] : payload;
            if (response.getClass().equals(AsyncFaultWrapper.class)) {
                future.setWrappedFault((AsyncFaultWrapper)response);
            } else if (response instanceof Throwable) {
                future.setFault((Throwable)response);
            } else {
                future.setResponse(response);
            }
        }
    }

    public void registerAsyncResponse(String id, Object responseHandler) {
        if (id != null && responseHandler != null) {
            this.asyncMessageMap.put(id, responseHandler);
        }
    }

    public Object getAsyncResponse(String id) {
        return this.asyncMessageMap.get(id);
    }

    private String getMessageRelatesID(Message msg) {
        return (String)msg.getHeaders().get("RELATES_TO");
    }
}

