/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.factory.InstanceWrapper;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactory;
import org.apache.tuscany.sca.implementation.java.context.ReflectiveInstanceWrapper;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvoker;

public class ReflectiveInstanceFactory<T>
implements InstanceFactory<T> {
    private static final Logger logger = Logger.getLogger(ReflectiveInstanceFactory.class.getName(), "org.apache.tuscany.sca.implementation.java.runtime.implementation-java-runtime-validation-messages");
    private final Constructor<T> ctr;
    private final ObjectFactory<?>[] ctrArgs;
    private final Injector<T>[] injectors;
    private final EventInvoker<T> initInvoker;
    private final EventInvoker<T> destroyInvoker;
    private final Injector<T>[] callbackInjectors;

    public ReflectiveInstanceFactory(Constructor<T> ctr, ObjectFactory<?>[] ctrArgs, Injector<T>[] injectors, Injector<T>[] callbackInjectors, EventInvoker<T> initInvoker, EventInvoker<T> destroyInvoker) {
        this.ctr = ctr;
        this.ctrArgs = ctrArgs;
        this.injectors = injectors;
        this.callbackInjectors = callbackInjectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
    }

    @Override
    public InstanceWrapper<T> newInstance() {
        T instance;
        try {
            if (this.ctrArgs != null) {
                Object[] args = new Object[this.ctrArgs.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.ctrArgs[i].getInstance();
                }
                instance = this.ctr.newInstance(args);
            } else {
                instance = this.ctr.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException e) {
            String name = this.ctr.getDeclaringClass().getName();
            String message = logger.getResourceBundle().getString("ClassNoInstantiable");
            message = message.replace("{0}", name);
            throw new AssertionError((Object)message);
        }
        catch (IllegalAccessException e) {
            String name = this.ctr.getName();
            String message = logger.getResourceBundle().getString("ConstructorNotAccessible");
            message = message.replace("{0}", name);
            throw new AssertionError((Object)message);
        }
        catch (InvocationTargetException e) {
            String name = this.ctr.getName();
            String message = logger.getResourceBundle().getString("ConstructorException");
            message = message.replace("{0}", name);
            throw new ObjectCreationException(message, (Throwable)e);
        }
        if (this.injectors != null) {
            for (Injector<T> injector : this.injectors) {
                if (injector == null) continue;
                try {
                    injector.inject(instance);
                }
                catch (Exception e) {
                    if (this.destroyInvoker != null) {
                        this.destroyInvoker.invokeEvent(instance);
                    }
                    String message = logger.getResourceBundle().getString("InjectorException");
                    message = message.replace("{0}", e.getMessage());
                    throw new ObjectCreationException(message, (Throwable)e);
                }
            }
        }
        return new ReflectiveInstanceWrapper<T>(instance, this.initInvoker, this.destroyInvoker, this.callbackInjectors);
    }
}

