/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;
import org.apache.tuscany.sca.host.webapp.WebContextConfigurator;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.oasisopen.sca.ServiceRuntimeException;

public class WebAppHelper {
    private static final String ROOT = "/";
    private static final String CONTRIBUTIONS = "contributions";
    private static final String DEFAULT_CONTRIBUTIONS = "/WEB-INF/sca-contributions";
    private static final String CONTRIBUTION = "contribution";
    private static final String NODE_CONFIGURATION = "node.configuration";
    private static final String DOMAIN_URI = "domain.uri";
    private static final String DOMAIN_REGISTRY_URI = "domain.registry.uri";
    private static final String NODE_URI = "node.uri";
    private static final String COMPOSITE_URI = "composite.uri";
    public static final String DOMAIN_NAME_ATTR = "org.apache.tuscany.sca.domain.name";
    public static final String DOMAIN_URI_PROP = "domainURI";
    public static final String SCA_NODE_ATTRIBUTE = Node.class.getName();
    private static NodeFactory factory;
    private static WebAppServletHost host;

    private static URL getResource(ServletContext servletContext, String location) throws IOException {
        URL url;
        URI uri = URI.create(location);
        if (uri.isAbsolute()) {
            return uri.toURL();
        }
        String path = location;
        if (!path.startsWith(ROOT)) {
            path = ROOT + path;
        }
        if ((url = servletContext.getResource(path)) != null && url.getProtocol().equals("jndi")) {
            File warRootFile = new File(servletContext.getRealPath(path));
            return warRootFile.toURI().toURL();
        }
        return url;
    }

    private static String[] parse(String listOfValues) {
        if (listOfValues == null) {
            return null;
        }
        return listOfValues.split("(\\s|,)+");
    }

    private static String getDomainName(String configURI) {
        int i;
        String domainName = configURI.startsWith("tuscany:vm:") ? configURI.substring("tuscany:vm:".length()) : (configURI.startsWith("uri:") ? ((i = configURI.indexOf(63)) == -1 ? configURI.substring("uri:".length()) : configURI.substring("uri:".length(), i)) : configURI);
        return domainName;
    }

    public static WebAppServletHost getServletHost() {
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node init(WebContextConfigurator configurator) {
        WebContextConfigurator webContextConfigurator = configurator;
        synchronized (webContextConfigurator) {
            WebAppHelper.bootstrapRuntime(configurator);
            Node node = (Node)configurator.getAttribute(SCA_NODE_ATTRIBUTE);
            if (node == null) {
                try {
                    node = WebAppHelper.createAndStartNode(configurator);
                }
                catch (ServletException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
                configurator.setAttribute(SCA_NODE_ATTRIBUTE, node);
            }
            return node;
        }
    }

    private static synchronized void bootstrapRuntime(WebContextConfigurator configurator) {
        if (host == null) {
            try {
                String configValue = configurator.getInitParameter("org.apache.tuscany.sca.config");
                factory = configValue != null ? NodeFactory.newInstance((String)configValue) : NodeFactory.newInstance();
                ExtensionPointRegistry registry = factory.getExtensionPointRegistry();
                UtilityExtensionPoint utilityExtensionPoint = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
                utilityExtensionPoint.addUtility(ServletContext.class, (Object)configurator.getServletContext());
                ServletHostExtensionPoint servletHosts = (ServletHostExtensionPoint)registry.getExtensionPoint(ServletHostExtensionPoint.class);
                servletHosts.setWebApp(true);
                host = WebAppHelper.getServletHost(configurator);
            }
            catch (ServletException e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
    }

    private static WebAppServletHost getServletHost(final WebContextConfigurator configurator) throws ServletException {
        ExtensionPointRegistry registry = factory.getExtensionPointRegistry();
        WebAppServletHost host = (WebAppServletHost)ServletHostHelper.getServletHost((ExtensionPointRegistry)registry);
        host.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return configurator.getInitParameter(name);
            }

            public Enumeration<?> getInitParameterNames() {
                return configurator.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return configurator.getServletContext();
            }

            public String getServletName() {
                return configurator.getServletContext().getServletContextName();
            }
        });
        return host;
    }

    private static Node createAndStartNode(WebContextConfigurator configurator) throws ServletException {
        NodeConfiguration configuration = null;
        try {
            configuration = WebAppHelper.getNodeConfiguration(configurator);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        Node node = null;
        if (configuration != null) {
            node = factory.createNode(configuration).start();
        }
        return node;
    }

    public static void stop(WebContextConfigurator configurator) {
        Node node = null;
        if (configurator != null) {
            node = (Node)configurator.getAttribute(SCA_NODE_ATTRIBUTE);
        }
        if (node != null) {
            node.stop();
            configurator.setAttribute(SCA_NODE_ATTRIBUTE, null);
        }
    }

    public static void destroy() {
        if (factory != null) {
            factory.destroy();
        }
        factory = null;
        host = null;
    }

    public static NodeFactory getNodeFactory() {
        return factory;
    }

    private static String getDefaultComposite(WebContextConfigurator configurator) {
        String name = configurator.getName();
        if ("".equals(name)) {
            return "/WEB-INF/web.composite";
        }
        return "/WEB-INF/" + name + "/servlet.composite";
    }

    private static NodeConfiguration getNodeConfiguration(WebContextConfigurator configurator) throws IOException, URISyntaxException {
        NodeConfiguration configuration = null;
        String nodeConfigURI = configurator.getInitParameter(NODE_CONFIGURATION);
        ServletContext servletContext = configurator.getServletContext();
        if (nodeConfigURI != null) {
            URL url = WebAppHelper.getResource(servletContext, nodeConfigURI);
            configuration = factory.loadConfiguration(url.openStream(), url);
        } else {
            String nodeURI;
            File f;
            URL url;
            configuration = factory.createNodeConfiguration();
            boolean explicitContributions = false;
            Enumeration<String> names = configurator.getInitParameterNames();
            while (names.hasMoreElements()) {
                File f2;
                String listOfValues;
                String name = names.nextElement();
                if (name.equals(CONTRIBUTION) || name.startsWith("contribution.")) {
                    explicitContributions = true;
                    listOfValues = configurator.getInitParameter(name);
                    if (listOfValues == null) continue;
                    for (String path : WebAppHelper.parse(listOfValues)) {
                        if ("".equals(path)) continue;
                        f2 = new File(WebAppHelper.getResource(servletContext, path).toURI());
                        configuration.addContribution(new URL[]{f2.toURI().toURL()});
                    }
                    continue;
                }
                if (!name.equals(CONTRIBUTIONS) && !name.startsWith("contributions.")) continue;
                explicitContributions = true;
                listOfValues = configurator.getInitParameter(name);
                if (listOfValues == null) continue;
                for (String path : WebAppHelper.parse(listOfValues)) {
                    if ("".equals(path)) continue;
                    f2 = new File(WebAppHelper.getResource(servletContext, path).toURI());
                    if (f2.isDirectory()) {
                        for (File n : f2.listFiles()) {
                            configuration.addContribution(new URL[]{n.toURI().toURL()});
                        }
                        continue;
                    }
                    configuration.addContribution(new URL[]{f2.toURI().toURL()});
                }
            }
            String compositeURI = configurator.getInitParameter(COMPOSITE_URI);
            if (compositeURI == null) {
                compositeURI = WebAppHelper.getDefaultComposite(configurator);
            }
            URL composite = WebAppHelper.getResource(servletContext, compositeURI);
            if (configuration.getContributions().isEmpty() || !explicitContributions && composite != null) {
                if ("".equals(configurator.getName())) {
                    configuration.addContribution(new URL[]{WebAppHelper.getResource(servletContext, ROOT)});
                } else {
                    configuration.addContribution(URI.create("sca:contributions/" + configurator.getName()), null);
                }
            }
            if (composite != null) {
                ((ContributionConfiguration)configuration.getContributions().get(0)).addDeploymentComposite(composite);
            }
            if (!explicitContributions && (url = WebAppHelper.getResource(servletContext, DEFAULT_CONTRIBUTIONS)) != null && (f = new File(url.toURI())).isDirectory()) {
                for (File n : f.listFiles()) {
                    configuration.addContribution(new URL[]{n.toURI().toURL()});
                }
            }
            if ((nodeURI = configurator.getInitParameter(NODE_URI)) == null) {
                nodeURI = WebAppHelper.getResource(servletContext, ROOT).getPath() + configurator.getName();
            }
            configuration.setURI(nodeURI);
            String domainURI = configurator.getInitParameter(DOMAIN_URI);
            if (domainURI != null) {
                configuration.setDomainURI(domainURI);
            } else {
                domainURI = configurator.getInitParameter("org.apache.tuscany.sca.defaultDomainURI");
                if (domainURI == null) {
                    domainURI = System.getProperty(DOMAIN_URI_PROP);
                }
                if (domainURI != null) {
                    configuration.setDomainURI(WebAppHelper.getDomainName(domainURI));
                    configuration.setDomainRegistryURI(domainURI);
                }
            }
            String domainRegistryURI = configurator.getInitParameter(DOMAIN_REGISTRY_URI);
            if (domainRegistryURI != null) {
                configuration.setDomainRegistryURI(domainRegistryURI);
            }
        }
        configuration.setAttribute(ServletContext.class.getName(), (Object)servletContext);
        if (configurator instanceof ServletConfigurator) {
            configuration.setAttribute(Servlet.class.getName(), (Object)((ServletConfigurator)configurator).servlet);
        }
        return configuration;
    }

    public static WebContextConfigurator getConfigurator(FilterConfig config) {
        return new FilterConfigurator(config);
    }

    public static WebContextConfigurator getConfigurator(ServletContext context) {
        return new ServletContextConfigurator(context);
    }

    public static WebContextConfigurator getConfigurator(Servlet context) {
        return new ServletConfigurator(context);
    }

    public static class ServletConfigurator
    implements WebContextConfigurator {
        private ServletConfig config;
        private Servlet servlet;

        public ServletConfigurator(Servlet servlet) {
            this.servlet = servlet;
            this.config = servlet.getServletConfig();
        }

        @Override
        public String getInitParameter(String name) {
            String value = this.config.getInitParameter(name);
            return value;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        @Override
        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        @Override
        public void setAttribute(String name, Object value) {
            String prefix = "servlet:" + this.config.getServletName() + ":";
            this.getServletContext().setAttribute(prefix + name, value);
        }

        @Override
        public <T> T getAttribute(String name) {
            String prefix = "servlet:" + this.config.getServletName() + ":";
            return (T)this.getServletContext().getAttribute(prefix + name);
        }

        @Override
        public String getName() {
            return this.config.getServletName();
        }
    }

    public static class ServletContextConfigurator
    implements WebContextConfigurator {
        private ServletContext context;

        public ServletContextConfigurator(ServletContext context) {
            this.context = context;
        }

        @Override
        public String getInitParameter(String name) {
            return this.context.getInitParameter(name);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return this.context.getInitParameterNames();
        }

        @Override
        public ServletContext getServletContext() {
            return this.context;
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.context.setAttribute(name, value);
        }

        @Override
        public <T> T getAttribute(String name) {
            return (T)this.context.getAttribute(name);
        }

        @Override
        public String getName() {
            return "";
        }
    }

    public static class FilterConfigurator
    implements WebContextConfigurator {
        private FilterConfig config;

        public FilterConfigurator(FilterConfig config) {
            this.config = config;
        }

        @Override
        public String getInitParameter(String name) {
            String value = this.config.getInitParameter(name);
            if (value == null) {
                return this.config.getServletContext().getInitParameter(name);
            }
            return value;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            Enumeration names = this.config.getInitParameterNames();
            if (!names.hasMoreElements()) {
                return this.getServletContext().getInitParameterNames();
            }
            return names;
        }

        @Override
        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        @Override
        public void setAttribute(String name, Object value) {
            String prefix = "filter:" + this.config.getFilterName() + ":";
            this.getServletContext().setAttribute(prefix + name, value);
            if (this.getServletContext().getAttribute(name) == null) {
                this.getServletContext().setAttribute(name, value);
            }
        }

        @Override
        public <T> T getAttribute(String name) {
            String prefix = "filter:" + this.config.getFilterName() + ":";
            Object value = this.getServletContext().getAttribute(prefix + name);
            if (value != null) {
                return (T)value;
            }
            return (T)this.getServletContext().getAttribute(name);
        }

        @Override
        public String getName() {
            return "";
        }
    }
}

