/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.deployment.impl;

import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ExtendedURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.DefaultImportModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.definitions.DefinitionsFactory;
import org.apache.tuscany.sca.definitions.util.DefinitionsUtil;
import org.apache.tuscany.sca.definitions.xml.DefinitionsExtensionPoint;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.deployment.impl.Contributions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.BaseDomainRegistry;
import org.apache.tuscany.sca.runtime.ContributionDescription;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.EndpointReferenceBinder;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;

public class DeployerImpl
implements Deployer {
    protected static final Logger logger = Logger.getLogger(DeployerImpl.class.getName());
    protected boolean inited;
    protected boolean schemaValidationEnabled;
    protected StAXHelper staxHelper;
    protected AssemblyFactory assemblyFactory;
    protected CompositeBuilder compositeBuilder;
    protected ContributionFactory contributionFactory;
    protected ExtendedURLArtifactProcessor<Contribution> contributionProcessor;
    protected ExtensionPointRegistry registry;
    protected FactoryExtensionPoint modelFactories;
    protected ModelResolverExtensionPoint modelResolvers;
    protected Contribution systemContribution;
    protected Definitions systemDefinitions;
    protected ExtensibleURLArtifactProcessor artifactProcessor;
    protected ExtensibleStAXArtifactProcessor staxProcessor;
    protected ValidationSchemaExtensionPoint validationSchema;
    protected EndpointReferenceBinder endpointReferenceBinder;
    protected MonitorFactory monitorFactory;
    protected static final String DEPLOYER_IMPL_VALIDATION_MESSAGES = "org.apache.tuscany.sca.deployment.impl.deployer-impl-validation-messages";
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");

    public DeployerImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Monitor createMonitor() {
        this.init();
        return this.monitorFactory.createMonitor();
    }

    public synchronized void stop() {
        if (this.inited) {
            this.staxHelper = null;
            this.assemblyFactory = null;
            this.compositeBuilder = null;
            this.contributionFactory = null;
            this.contributionProcessor = null;
            this.modelFactories = null;
            this.modelResolvers = null;
            this.systemContribution = null;
            this.systemDefinitions = null;
            this.artifactProcessor = null;
            this.staxProcessor = null;
            this.monitorFactory = null;
            this.inited = false;
        }
    }

    protected void addContributionDependencies(Contribution contribution, List<Contribution> contributions, List<Contribution> dependencies, Set<Contribution> set, Monitor monitor) {
        for (Import import_ : contribution.getImports()) {
            boolean resolved = false;
            ArrayList<Export> matchingExports = new ArrayList<Export>();
            for (Contribution dependency : contributions) {
                JavaImport javaImport;
                NamespaceImport namespaceImport;
                if (dependency == contribution || import_ instanceof NamespaceImport && (namespaceImport = (NamespaceImport)import_).getLocation() != null && !namespaceImport.getLocation().equals(dependency.getURI()) || import_ instanceof JavaImport && (javaImport = (JavaImport)import_).getLocation() != null && !javaImport.getLocation().equals(dependency.getURI())) continue;
                for (Export export : dependency.getExports()) {
                    if (!import_.match(export)) continue;
                    resolved = true;
                    matchingExports.add(export);
                    if (set.contains(dependency)) continue;
                    set.add(dependency);
                    dependencies.add(dependency);
                    this.addContributionDependencies(dependency, contributions, dependencies, set, monitor);
                }
            }
            if (resolved) {
                import_.setModelResolver((ModelResolver)new DefaultImportModelResolver(matchingExports));
                continue;
            }
            if (import_ instanceof DefaultImport) continue;
            import_.setModelResolver((ModelResolver)new DefaultImportModelResolver(matchingExports));
            monitor.pushContext((Object)("Contribution: " + contribution.getURI()));
            Monitor.error((Monitor)monitor, (Object)this, (String)DEPLOYER_IMPL_VALIDATION_MESSAGES, (String)"UnresolvedImport", (Object[])new Object[]{import_});
            monitor.popContext();
        }
    }

    protected void buildDependencies(Contribution contribution, List<Contribution> contributions, Monitor monitor) {
        contribution.getDependencies().clear();
        ArrayList<Contribution> dependencies = new ArrayList<Contribution>();
        HashSet<Contribution> set = new HashSet<Contribution>();
        dependencies.add(contribution);
        set.add(contribution);
        this.addContributionDependencies(contribution, contributions, dependencies, set, monitor);
        Collections.reverse(dependencies);
        contribution.getDependencies().addAll(dependencies);
    }

    @Override
    public List<String> getDependencies(Map<String, ContributionMetadata> possibles, String targetURI, Monitor monitor) {
        HashMap<String, Contribution> contributions = new HashMap<String, Contribution>();
        for (String curi : possibles.keySet()) {
            Contribution c = this.contributionFactory.createContribution();
            c.setURI(curi);
            c.mergeMetaData(possibles.get(curi));
            contributions.put(curi, c);
        }
        Contribution tc = (Contribution)contributions.remove(targetURI);
        this.buildDependencies(tc, new ArrayList<Contribution>(contributions.values()), monitor);
        ArrayList<String> dcuris = new ArrayList<String>();
        for (Contribution dc : tc.getDependencies()) {
            dcuris.add(dc.getURI());
        }
        dcuris.remove(targetURI);
        return dcuris;
    }

    protected void contributionsPreresolve(List<Contribution> contributions, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (Contribution contribution : contributions) {
            this.contributionProcessor.preResolve((Object)contribution, resolver, context);
        }
    }

    @Override
    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.registry;
    }

    public void start() {
    }

    public synchronized void init() {
        ValidationSchemaExtensionPoint schemas;
        if (this.inited) {
            return;
        }
        if (this.isSchemaValidationEnabled() && (schemas = (ValidationSchemaExtensionPoint)this.registry.getExtensionPoint(ValidationSchemaExtensionPoint.class)) != null) {
            schemas.setEnabled(true);
        }
        this.modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)this.modelFactories.getFactory(AssemblyFactory.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.staxHelper = (StAXHelper)utilities.getUtility(StAXHelper.class);
        this.monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        this.registry.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        this.contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
        this.staxProcessor = new ExtensibleStAXArtifactProcessor(this.registry);
        URLArtifactProcessorExtensionPoint docProcessorExtensions = (URLArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.artifactProcessor = new ExtensibleURLArtifactProcessor(docProcessorExtensions);
        this.contributionProcessor = (ExtendedURLArtifactProcessor)docProcessorExtensions.getProcessor(Contribution.class);
        this.modelResolvers = (ModelResolverExtensionPoint)this.registry.getExtensionPoint(ModelResolverExtensionPoint.class);
        BuilderExtensionPoint compositeBuilders = (BuilderExtensionPoint)this.registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.compositeBuilder = compositeBuilders.getCompositeBuilder("org.apache.tuscany.sca.assembly.builder.CompositeBuilder");
        this.validationSchema = (ValidationSchemaExtensionPoint)this.registry.getExtensionPoint(ValidationSchemaExtensionPoint.class);
        this.endpointReferenceBinder = (EndpointReferenceBinder)this.registry.getExtensionPoint(EndpointReferenceBinder.class);
        this.loadSystemContribution(new ProcessorContext(this.monitorFactory.createMonitor()));
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSystemContribution(ProcessorContext context) {
        DefinitionsFactory definitionsFactory = (DefinitionsFactory)this.modelFactories.getFactory(DefinitionsFactory.class);
        this.systemDefinitions = definitionsFactory.createDefinitions();
        DefinitionsExtensionPoint definitionsExtensionPoint = (DefinitionsExtensionPoint)this.registry.getExtensionPoint(DefinitionsExtensionPoint.class);
        Monitor monitor = context.getMonitor();
        monitor.pushContext((Object)"Extension points definitions");
        try {
            for (Definitions defs : definitionsExtensionPoint.getDefinitions()) {
                DefinitionsUtil.aggregate((Definitions)defs, (Definitions)this.systemDefinitions, (Monitor)monitor);
            }
        }
        finally {
            monitor.popContext();
        }
        this.systemContribution = this.contributionFactory.createContribution();
        this.systemContribution.setURI("http://tuscany.apache.org/SystemContribution");
        this.systemContribution.setLocation("http://tuscany.apache.org/SystemContribution");
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver(this.systemContribution, this.modelResolvers, this.modelFactories);
        this.systemContribution.setModelResolver((ModelResolver)modelResolver);
        this.systemContribution.setUnresolved(true);
        List artifacts = this.systemContribution.getArtifacts();
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI("http://tuscany.apache.org/SystemContribution/Definitions");
        artifact.setLocation("Derived");
        artifact.setModel((Object)this.systemDefinitions);
        artifacts.add(artifact);
        try {
            this.contributionProcessor.resolve((Object)this.systemContribution, (ModelResolver)modelResolver, context);
        }
        catch (ContributionResolveException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Contribution cloneSystemContribution(Monitor monitor) {
        this.init();
        Contribution contribution = this.contributionFactory.createContribution();
        contribution.setURI(this.systemContribution.getURI());
        contribution.setLocation(this.systemContribution.getLocation());
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver(contribution, this.modelResolvers, this.modelFactories);
        contribution.setModelResolver((ModelResolver)modelResolver);
        contribution.setUnresolved(true);
        DefinitionsFactory definitionsFactory = (DefinitionsFactory)this.modelFactories.getFactory(DefinitionsFactory.class);
        Definitions definitions = definitionsFactory.createDefinitions();
        DefinitionsUtil.aggregate((Definitions)this.systemDefinitions, (Definitions)definitions, (Monitor)monitor);
        List artifacts = contribution.getArtifacts();
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI("http://tuscany.apache.org/SystemContribution/Definitions");
        artifact.setLocation("Derived");
        artifact.setModel((Object)definitions);
        artifacts.add(artifact);
        ProcessorContext context = new ProcessorContext(monitor);
        XSDFactory xsdFactory = (XSDFactory)this.modelFactories.getFactory(XSDFactory.class);
        List scaSchemas = this.validationSchema.getSchemas();
        for (String scaSchemaLocation : scaSchemas) {
            try {
                XSDefinition scaSchema;
                URL scaSchemaURL = new URL(scaSchemaLocation);
                String namespace = this.staxHelper.readAttribute(scaSchemaURL, XSD, "targetNamespace");
                if (namespace.equals("http://tuscany.apache.org/xmlns/sca/1.1")) {
                    scaSchema = xsdFactory.createXSDefinition();
                    scaSchema.setUnresolved(true);
                    scaSchema.setNamespace(namespace);
                    scaSchema.setLocation(IOHelper.toURI((URL)scaSchemaURL));
                    scaSchema.setUnresolved(false);
                    continue;
                }
                if (!namespace.equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) continue;
                scaSchema = xsdFactory.createXSDefinition();
                scaSchema.setUnresolved(true);
                scaSchema.setNamespace("http://docs.oasis-open.org/ns/opencsa/sca/200912");
                scaSchema.setLocation(IOHelper.toURI((URL)scaSchemaURL));
                scaSchema.setUnresolved(false);
                modelResolver.addModel((Object)scaSchema, context);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return contribution;
    }

    @Override
    public String attachDeploymentComposite(Contribution contribution, Composite composite, boolean appending) {
        this.init();
        String compositeArtifactURI = composite.getName().getLocalPart() + ".composite";
        if (appending) {
            for (Artifact a : contribution.getArtifacts()) {
                if (!compositeArtifactURI.equals(a.getURI())) continue;
                throw new IllegalStateException("artifact '" + compositeArtifactURI + "' already exists in contribution: " + contribution.getURI());
            }
        }
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI(compositeArtifactURI);
        artifact.setLocation(compositeArtifactURI);
        artifact.setModel((Object)composite);
        artifact.setUnresolved(false);
        contribution.getArtifacts().add(artifact);
        if (!appending) {
            contribution.getDeployables().clear();
        }
        contribution.getDeployables().add(composite);
        return compositeArtifactURI;
    }

    @Override
    public Composite build(List<Contribution> contributions, List<Contribution> allContributions, Map<QName, List<String>> bindingMap, Monitor monitor) throws ContributionResolveException, CompositeBuilderException {
        return this.build(contributions, allContributions, null, bindingMap, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Composite build(List<Contribution> contributions, List<Contribution> allContributions, Contribution systemContribution, Map<QName, List<String>> bindingMap, Monitor monitor) throws ContributionResolveException, CompositeBuilderException {
        this.init();
        ArrayList<Contribution> contributionList = new ArrayList<Contribution>(contributions);
        if (systemContribution == null) {
            systemContribution = this.cloneSystemContribution(monitor);
        }
        Definitions systemDefinitions = (Definitions)((Artifact)systemContribution.getArtifacts().get(0)).getModel();
        ProcessorContext context = new ProcessorContext(monitor);
        for (Contribution contribution : contributionList) {
            monitor.pushContext((Object)("Contribution: " + contribution.getURI()));
            try {
                for (Artifact artifact : contribution.getArtifacts()) {
                    Object model;
                    if (!"META-INF/definitions.xml".equals(artifact.getURI()) || !((model = artifact.getModel()) instanceof Definitions)) continue;
                    try {
                        monitor.pushContext((Object)("Definitions: " + artifact.getLocation()));
                        DefinitionsUtil.aggregate((Definitions)((Definitions)model), (Definitions)systemDefinitions, (Monitor)monitor);
                    }
                    finally {
                        monitor.popContext();
                    }
                }
                DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
                defaultImport.setModelResolver(systemContribution.getModelResolver());
                contribution.getImports().add(defaultImport);
            }
            finally {
                monitor.popContext();
            }
        }
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver((Contribution)new Contributions(contributionList), this.modelResolvers, this.modelFactories);
        this.contributionProcessor.resolve((Object)systemContribution, (ModelResolver)modelResolver, context);
        contributionList.add(systemContribution);
        this.contributionsPreresolve(contributionList, (ModelResolver)modelResolver, context);
        HashSet<Contribution> resolved = new HashSet<Contribution>();
        for (Contribution contribution : contributionList) {
            this.buildDependencies(contribution, allContributions, monitor);
            for (Contribution dependency : contribution.getDependencies()) {
                if (resolved.contains(dependency)) continue;
                resolved.add(dependency);
                this.contributionProcessor.resolve((Object)dependency, (ModelResolver)modelResolver, context);
            }
        }
        Composite domainComposite = this.assemblyFactory.createComposite();
        domainComposite.setName(Composite.DOMAIN_COMPOSITE);
        domainComposite.setURI("http://docs.oasis-open.org/ns/opencsa/sca/200912");
        for (Contribution contribution : contributionList) {
            for (Composite composite : contribution.getDeployables()) {
                try {
                    composite = (Composite)composite.clone();
                }
                catch (CloneNotSupportedException ex) {
                    // empty catch block
                }
                domainComposite.getIncludes().add(composite);
            }
        }
        BuilderContext builderContext = new BuilderContext(systemDefinitions, bindingMap, monitor);
        this.compositeBuilder.build(domainComposite, builderContext);
        if (!monitor.isErrorDetected()) {
            this.buildTimeReferenceBind(domainComposite, builderContext);
        }
        return domainComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(List<Contribution> contributionList, Contribution systemContribution, Monitor monitor) throws ContributionResolveException, CompositeBuilderException {
        this.init();
        if (systemContribution == null) {
            systemContribution = this.cloneSystemContribution(monitor);
        }
        Definitions systemDefinitions = (Definitions)((Artifact)systemContribution.getArtifacts().get(0)).getModel();
        ProcessorContext context = new ProcessorContext(monitor);
        for (Contribution contribution : contributionList) {
            monitor.pushContext((Object)("Contribution: " + contribution.getURI()));
            try {
                for (Artifact artifact : contribution.getArtifacts()) {
                    Object model;
                    if (!"META-INF/definitions.xml".equals(artifact.getURI()) || !((model = artifact.getModel()) instanceof Definitions)) continue;
                    try {
                        monitor.pushContext((Object)("Definitions: " + artifact.getLocation()));
                        DefinitionsUtil.aggregate((Definitions)((Definitions)model), (Definitions)systemDefinitions, (Monitor)monitor);
                    }
                    finally {
                        monitor.popContext();
                    }
                }
                DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
                defaultImport.setModelResolver(systemContribution.getModelResolver());
                contribution.getImports().add(defaultImport);
            }
            finally {
                monitor.popContext();
            }
        }
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver((Contribution)new Contributions(contributionList), this.modelResolvers, this.modelFactories);
        this.contributionProcessor.resolve((Object)systemContribution, (ModelResolver)modelResolver, context);
        contributionList.add(systemContribution);
        this.contributionsPreresolve(contributionList, (ModelResolver)modelResolver, context);
        HashSet<Contribution> resolved = new HashSet<Contribution>();
        for (Contribution contribution : contributionList) {
            this.buildDependencies(contribution, contributionList, monitor);
            for (Contribution dependency : contribution.getDependencies()) {
                if (resolved.contains(dependency)) continue;
                resolved.add(dependency);
                this.contributionProcessor.resolve((Object)dependency, (ModelResolver)modelResolver, context);
            }
        }
    }

    @Override
    public Artifact loadArtifact(URI uri, URL location, Monitor monitor) throws ContributionReadException {
        this.init();
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setLocation(location.toString());
        artifact.setURI(uri.toString());
        URLArtifactProcessorExtensionPoint artifactProcessors = (URLArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        ExtensibleURLArtifactProcessor processor = new ExtensibleURLArtifactProcessor(artifactProcessors);
        Object model = processor.read(null, uri, location, new ProcessorContext(monitor));
        artifact.setModel(model);
        return artifact;
    }

    @Override
    public <T> T loadDocument(URI uri, URL location, Monitor monitor) throws ContributionReadException {
        this.init();
        Object model = this.artifactProcessor.read(null, uri, location, new ProcessorContext(monitor));
        return (T)model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadXMLDocument(URL document, Monitor monitor) throws XMLStreamException, ContributionReadException {
        this.init();
        XMLStreamReader reader = this.staxHelper.createXMLStreamReader(document);
        reader.nextTag();
        ValidatingXMLInputFactory.setMonitor((XMLStreamReader)reader, (Monitor)monitor);
        try {
            Object object = this.loadXMLElement(reader, monitor);
            return object;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void saveXMLDocument(Object model, Writer writer, Monitor monitor) throws XMLStreamException, ContributionWriteException {
        this.init();
        XMLStreamWriter streamWriter = this.staxHelper.createXMLStreamWriter(writer);
        this.staxProcessor.write(model, streamWriter, new ProcessorContext(monitor));
    }

    @Override
    public void saveXMLElement(Object model, XMLStreamWriter writer, Monitor monitor) throws XMLStreamException, ContributionWriteException {
        this.init();
        this.staxProcessor.write(model, writer, new ProcessorContext(monitor));
    }

    public Object loadXMLElement(XMLStreamReader reader, Monitor monitor) throws ContributionReadException, XMLStreamException {
        this.init();
        return this.staxProcessor.read(reader, new ProcessorContext(monitor));
    }

    public Object loadXMLDocument(Reader document) throws XMLStreamException, ContributionReadException, ValidationException {
        Monitor monitor = this.createMonitor();
        Object model = this.loadXMLDocument(document, monitor);
        monitor.analyzeProblems();
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadXMLDocument(Reader document, Monitor monitor) throws XMLStreamException, ContributionReadException {
        this.init();
        XMLStreamReader reader = this.staxHelper.createXMLStreamReader(document);
        ValidatingXMLInputFactory.setMonitor((XMLStreamReader)reader, (Monitor)monitor);
        reader.nextTag();
        try {
            Object object = this.loadXMLElement(reader, monitor);
            return object;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public Contribution loadContribution(URI uri, URL location, Monitor monitor) throws ContributionReadException {
        this.init();
        ProcessorContext context = new ProcessorContext(monitor);
        Contribution contribution = (Contribution)this.contributionProcessor.read(null, uri, location, context);
        return contribution;
    }

    @Override
    public ProcessorContext createProcessorContext() {
        this.init();
        return new ProcessorContext(this.monitorFactory.createMonitor());
    }

    @Override
    public BuilderContext createBuilderContext() {
        this.init();
        return new BuilderContext(this.monitorFactory.createMonitor());
    }

    @Override
    public boolean isSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    @Override
    public void setSchemaValidationEnabled(boolean schemaValidationEnabled) {
        this.schemaValidationEnabled = schemaValidationEnabled;
    }

    @Override
    public Definitions getSystemDefinitions() {
        this.init();
        return this.systemDefinitions;
    }

    private void buildTimeReferenceBind(Composite domainComposite, BuilderContext context) {
        LocalEndpointRegistry domainRegistry = new LocalEndpointRegistry(this.registry);
        this.populateLocalRegistry(domainComposite, (DomainRegistry)domainRegistry, context);
        this.matchEndpointReferences(domainComposite, (DomainRegistry)domainRegistry, context);
    }

    private void populateLocalRegistry(Composite composite, DomainRegistry registry, BuilderContext context) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.populateLocalRegistry((Composite)implementation, registry, context);
            }
            for (ComponentService service : component.getServices()) {
                for (Endpoint endpoint : service.getEndpoints()) {
                    registry.addEndpoint(endpoint);
                }
            }
            for (ComponentReference reference : component.getReferences()) {
                for (EndpointReference epr : reference.getEndpointReferences()) {
                    if (!epr.getStatus().equals((Object)EndpointReference.Status.WIRED_TARGET_NOT_FOUND) && !epr.getStatus().equals((Object)EndpointReference.Status.WIRED_TARGET_IN_BINDING_URI)) continue;
                    registry.addEndpointReference(epr);
                }
            }
        }
    }

    private void matchEndpointReferences(Composite composite, DomainRegistry registry, BuilderContext builderContext) {
        for (EndpointReference endpointReference : registry.getEndpointReferences()) {
            this.endpointReferenceBinder.bindBuildTime(registry, endpointReference, builderContext);
        }
    }

    class LocalEndpointRegistry
    extends BaseDomainRegistry {
        private List<Endpoint> endpoints;

        public LocalEndpointRegistry(ExtensionPointRegistry registry) {
            super(registry, null, "", "");
            this.endpoints = new ArrayList<Endpoint>();
        }

        public void addEndpoint(Endpoint endpoint) {
            this.endpoints.add(endpoint);
            this.endpointAdded(endpoint);
        }

        public void removeEndpoint(Endpoint endpoint) {
        }

        public Collection<Endpoint> getEndpoints() {
            return this.endpoints;
        }

        public Endpoint getEndpoint(String uri) {
            return null;
        }

        public List<Endpoint> findEndpoint(String uri) {
            ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
            for (Endpoint endpoint : this.endpoints) {
                if (!endpoint.matches(uri)) continue;
                foundEndpoints.add(endpoint);
                logger.fine("Found endpoint with matching service  - " + endpoint);
            }
            return foundEndpoints;
        }

        public void start() {
        }

        public void stop() {
        }

        public List<String> getInstalledContributionURIs() {
            return null;
        }

        public void uninstallContribution(String uri) {
        }

        public void installContribution(ContributionDescription cd) {
        }

        public ContributionDescription getInstalledContribution(String uri) {
            return null;
        }

        public void addRunningComposite(String contributionURI, Composite composite) {
        }

        public void removeRunningComposite(String contributionURI, String compositeURI) {
        }

        public Composite getRunningComposite(String contributionURI, String compositeURI) {
            return null;
        }

        public Map<String, List<String>> getRunningCompositeURIs() {
            return null;
        }

        public void updateInstalledContribution(ContributionDescription cd) {
        }

        public List<String> getNodeNames() {
            return null;
        }

        public String getLocalNodeName() {
            return null;
        }

        public String getRunningNodeName(String contributionURI, String compositeURI) {
            return null;
        }

        public String remoteCommand(String memberName, Callable<String> command) {
            return null;
        }

        public String getContainingCompositesContributionURI(String componentName) {
            return null;
        }

        public boolean isDistributed() {
            return false;
        }
    }
}

