/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ContributionMetadataProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ContributionMetadata> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName CONTRIBUTION_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "contribution");
    private static final QName DEPLOYABLE_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "deployable");
    private final AssemblyFactory assemblyFactory;
    private final ContributionFactory contributionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;

    public ContributionMetadataProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor) {
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return CONTRIBUTION_QNAME;
    }

    @Override
    public Class<ContributionMetadata> getModelType() {
        return ContributionMetadata.class;
    }

    @Override
    public ContributionMetadata read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        ContributionMetadata contribution = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        name = reader.getName();
                        if (CONTRIBUTION_QNAME.equals(name)) {
                            contribution = this.contributionFactory.createContributionMetadata();
                            contribution.setSpecVersion(SCA11_NS);
                            contribution.setUnresolved(true);
                            this.readExtendedAttributes(reader, contribution, this.attributeProcessor, this.assemblyFactory, context);
                            break;
                        }
                        if (DEPLOYABLE_QNAME.equals(name)) {
                            QName compositeName = this.getQName(reader, "composite");
                            if (compositeName == null) {
                                this.error(context.getMonitor(), "AttributeCompositeMissing", (Object)reader, new Object[0]);
                                break;
                            }
                            if (contribution == null) break;
                            Composite composite = this.assemblyFactory.createComposite();
                            composite.setName(compositeName);
                            composite.setUnresolved(true);
                            contribution.getDeployables().add(composite);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader, context);
                        if (extension == null || contribution == null) break;
                        if (extension instanceof Import) {
                            if (extension instanceof JavaImport) {
                                for (Import imports : contribution.getImports()) {
                                    if (!(imports instanceof JavaImport) || !((JavaImport)extension).getPackage().equals(((JavaImport)imports).getPackage())) continue;
                                    this.error(context.getMonitor(), "DuplicateJavaImports", (Object)reader, new Object[0]);
                                }
                            }
                            contribution.getImports().add((Import)extension);
                            break;
                        }
                        if (extension instanceof Export) {
                            if (extension instanceof JavaExport) {
                                for (Export exports : contribution.getExports()) {
                                    if (!(exports instanceof JavaExport) || !((JavaExport)extension).getPackage().equals(((JavaExport)exports).getPackage())) continue;
                                    this.error(context.getMonitor(), "DuplicateJavaExports", (Object)reader, new Object[0]);
                                }
                            }
                            contribution.getExports().add((Export)extension);
                            break;
                        }
                        contribution.getExtensions().add(extension);
                        break;
                    }
                    case 2: {
                        if (!CONTRIBUTION_QNAME.equals(reader.getName())) break;
                        return contribution;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", (Object)reader, ex);
        }
        return contribution;
    }

    @Override
    public void write(ContributionMetadata contribution, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, CONTRIBUTION_QNAME.getNamespaceURI(), CONTRIBUTION_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        this.writeExtendedAttributes(writer, contribution, this.attributeProcessor, context);
        for (Import imp : contribution.getImports()) {
            this.extensionProcessor.write(imp, writer, context);
        }
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.write(export, writer, context);
        }
        for (Composite deployable : contribution.getDeployables()) {
            this.writeStart(writer, DEPLOYABLE_QNAME.getNamespaceURI(), DEPLOYABLE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("composite", deployable.getName()));
            this.writeEnd(writer);
        }
        this.writeEndDocument(writer);
    }

    @Override
    public void resolve(ContributionMetadata contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.resolve(export, resolver, context);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, resolver, context);
        }
        List<Composite> deployables = contribution.getDeployables();
        int n = deployables.size();
        for (int i = 0; i < n; ++i) {
            Composite deployable = deployables.get(i);
            Composite resolved = resolver.resolveModel(Composite.class, deployable, context);
            if (resolved == deployable) continue;
            deployables.set(i, resolved);
        }
        for (Object ext : contribution.getExtensions()) {
            this.extensionProcessor.resolve(ext, resolver, context);
        }
        contribution.setUnresolved(false);
    }
}

