/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.DefaultExport;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ExtendedURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.scanner.ContributionScannerExtensionPoint;
import org.apache.tuscany.sca.contribution.scanner.impl.DirectoryContributionScanner;
import org.apache.tuscany.sca.contribution.scanner.impl.JarContributionScanner;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

public class ContributionContentProcessor
implements ExtendedURLArtifactProcessor<Contribution> {
    private ContributionFactory contributionFactory;
    private ModelResolverExtensionPoint modelResolvers;
    private FactoryExtensionPoint modelFactories;
    private URLArtifactProcessor<Object> artifactProcessor;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private ContributionScannerExtensionPoint scanners;
    private boolean preResolved = false;

    public ContributionContentProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor) {
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.modelResolvers = (ModelResolverExtensionPoint)extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        URLArtifactProcessorExtensionPoint artifactProcessors = (URLArtifactProcessorExtensionPoint)extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.artifactProcessor = new ExtensibleURLArtifactProcessor(artifactProcessors);
        this.extensionProcessor = extensionProcessor;
        this.contributionFactory = (ContributionFactory)this.modelFactories.getFactory(ContributionFactory.class);
        this.scanners = (ContributionScannerExtensionPoint)extensionPoints.getExtensionPoint(ContributionScannerExtensionPoint.class);
    }

    @Override
    public String getArtifactType() {
        return ".contribution/content";
    }

    @Override
    public Class<Contribution> getModelType() {
        return Contribution.class;
    }

    private File toFile(URL url) {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                return new File(url.getPath());
            }
            catch (IllegalArgumentException e) {
                return new File(url.getPath());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contribution read(URL parentURL, URI contributionURI, URL contributionURL, ProcessorContext context) throws ContributionReadException {
        Contribution contribution;
        block22: {
            contribution = this.contributionFactory.createContribution();
            contribution.setURI(contributionURI.toString());
            if (contributionURL != null) {
                contribution.setLocation(contributionURL.toString());
            }
            ExtensibleModelResolver modelResolver = new ExtensibleModelResolver(contribution, this.modelResolvers, this.modelFactories);
            contribution.setModelResolver(modelResolver);
            contribution.setUnresolved(true);
            Monitor monitor = context.getMonitor();
            monitor.pushContext((Object)("Contribution: " + contribution.getURI()));
            Contribution old = context.setContribution(contribution);
            try {
                if (contributionURL == null) break block22;
                ContributionScanner scanner = this.scanners.getContributionScanner(contributionURL.getProtocol());
                if (scanner == null) {
                    File file = this.toFile(contributionURL);
                    scanner = file != null && file.isDirectory() ? new DirectoryContributionScanner(this.contributionFactory) : new JarContributionScanner(this.contributionFactory);
                }
                boolean contributionMetadata = false;
                List<Artifact> artifacts = scanner.scan(contribution);
                for (Artifact artifact : artifacts) {
                    modelResolver.addModel(artifact, context);
                    monitor.pushContext((Object)("Artifact: " + artifact.getURI()));
                    Artifact oldArtifact = context.setArtifact(artifact);
                    try {
                        Object model;
                        URL artifactLocationURL = null;
                        try {
                            artifactLocationURL = new URL(artifact.getLocation());
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                        if ((model = this.artifactProcessor.read(contributionURL, URI.create(artifact.getURI()), artifactLocationURL, context)) == null) continue;
                        artifact.setModel(model);
                        modelResolver.addModel(model, context);
                        if (!(model instanceof ContributionMetadata)) continue;
                        contributionMetadata = true;
                        ContributionMetadata c = (ContributionMetadata)model;
                        contribution.getImports().addAll(c.getImports());
                        contribution.getExports().addAll(c.getExports());
                        contribution.getDeployables().addAll(c.getDeployables());
                        contribution.getExtensions().addAll(c.getExtensions());
                        contribution.getAttributeExtensions().addAll(c.getAttributeExtensions());
                    }
                    finally {
                        monitor.popContext();
                        context.setArtifact(oldArtifact);
                    }
                }
                List<Artifact> contributionArtifacts = contribution.getArtifacts();
                contributionArtifacts.addAll(artifacts);
                if (contribution.useNestedArchives() && !this.isWebApp(contribution)) {
                    List<URL> nestedArchiveURLs;
                    List<Artifact> nestedArchives = this.getNestedArchives(contribution);
                    if (scanner instanceof DirectoryContributionScanner) {
                        nestedArchiveURLs = this.getNestedArchiveURLs(nestedArchives, contribution.getLocation());
                    } else {
                        try {
                            nestedArchiveURLs = this.extractNestedArchives(nestedArchives, contribution.getLocation());
                        }
                        catch (IOException e) {
                            throw new ContributionReadException(e);
                        }
                    }
                    this.processNestedArchives(nestedArchiveURLs, contribution, context, monitor);
                }
                if (!contributionMetadata) {
                    for (Artifact artifact : artifacts) {
                        if (!(artifact.getModel() instanceof Composite)) continue;
                        contribution.getDeployables().add((Composite)artifact.getModel());
                    }
                    DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
                    defaultImport.setModelResolver(new DefaultModelResolver());
                    contribution.getImports().add(defaultImport);
                    DefaultExport defaultExport = this.contributionFactory.createDefaultExport();
                    contribution.getExports().add(defaultExport);
                } else if (contribution.getDeployables().size() > 0) {
                    for (Artifact a : contribution.getArtifacts()) {
                        if (!(a.getModel() instanceof Composite)) continue;
                        ListIterator<Composite> lit = contribution.getDeployables().listIterator();
                        while (lit.hasNext()) {
                            if (!lit.next().getName().equals(((Composite)a.getModel()).getName())) continue;
                            lit.set((Composite)a.getModel());
                        }
                    }
                }
            }
            finally {
                monitor.popContext();
                context.setContribution(old);
            }
        }
        return contribution;
    }

    private List<URL> getNestedArchiveURLs(List<Artifact> nestedArchives, String location) throws ContributionReadException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact a : nestedArchives) {
            try {
                urls.add(new URL(a.getLocation()));
            }
            catch (MalformedURLException e) {
                throw new ContributionReadException(e);
            }
        }
        return urls;
    }

    private boolean isWebApp(Contribution contribution) {
        for (Artifact a : contribution.getArtifacts()) {
            if (!a.getURI().equalsIgnoreCase("web-inf/web.xml")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNestedArchives(List<URL> nestedArchiveURLs, Contribution contribution, ProcessorContext context, Monitor monitor) throws ContributionReadException {
        for (URL url : nestedArchiveURLs) {
            Contribution tempC = this.contributionFactory.createContribution();
            tempC.setURI("temp");
            tempC.setLocation(url.toString());
            JarContributionScanner scanner = new JarContributionScanner(this.contributionFactory);
            List<Artifact> artifacts = scanner.scan(tempC);
            for (Artifact artifact : artifacts) {
                contribution.getModelResolver().addModel(artifact, context);
                monitor.pushContext((Object)("Artifact: " + artifact.getURI()));
                Artifact oldArtifact = context.setArtifact(artifact);
                try {
                    Object model;
                    URL artifactLocationURL = null;
                    try {
                        artifactLocationURL = new URL(artifact.getLocation());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    try {
                        model = this.artifactProcessor.read(new URL(contribution.getLocation()), URI.create(artifact.getURI()), artifactLocationURL, context);
                    }
                    catch (MalformedURLException e) {
                        throw new ContributionReadException(e);
                    }
                    if (model == null) continue;
                    artifact.setModel(model);
                    contribution.getModelResolver().addModel(model, context);
                }
                finally {
                    monitor.popContext();
                    context.setArtifact(oldArtifact);
                }
            }
            contribution.getArtifacts().addAll(artifacts);
            contribution.getExtractedArchives().add(url);
        }
    }

    private List<Artifact> getNestedArchives(Contribution contribution) {
        ArrayList<Artifact> nestedArchives = new ArrayList<Artifact>();
        for (Artifact a : contribution.getArtifacts()) {
            if (!a.getURI().endsWith(".zip") && !a.getURI().endsWith(".jar")) continue;
            nestedArchives.add(a);
        }
        return nestedArchives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> extractNestedArchives(List<Artifact> nestedArchives, String contributionLocation) throws IOException {
        if (nestedArchives.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<URL> extractedArchiveURLs = new ArrayList<URL>();
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(new File(URI.create(contributionLocation))));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                for (Artifact artifact : nestedArchives) {
                    int n;
                    if (!artifact.getLocation().endsWith(zipEntry.getName())) continue;
                    String tempName = ("tmp." + artifact.getURI().substring(0, artifact.getURI().length() - 3)).replace('/', '.');
                    File tempFile = File.createTempFile(tempName, ".jar");
                    tempFile.deleteOnExit();
                    fileOutputStream = new FileOutputStream(tempFile);
                    byte[] buf = new byte[4096];
                    while ((n = zipInputStream.read(buf, 0, buf.length)) > -1) {
                        fileOutputStream.write(buf, 0, n);
                    }
                    fileOutputStream.close();
                    zipInputStream.closeEntry();
                    extractedArchiveURLs.add(tempFile.toURI().toURL());
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return extractedArchiveURLs;
    }

    @Override
    public void preResolve(Contribution contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        ModelResolver contributionResolver = contribution.getModelResolver();
        contribution.setUnresolved(false);
        contributionResolver.addModel(contribution, context);
        this.resolveExports(contribution, contributionResolver, context);
        this.resolveImports(contribution, contributionResolver, context);
        this.preResolved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(Contribution contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        Contribution old = context.setContribution(contribution);
        try {
            monitor.pushContext((Object)("Contribution: " + contribution.getURI()));
            if (!this.preResolved) {
                this.preResolve(contribution, resolver, context);
            }
            ModelResolver contributionResolver = contribution.getModelResolver();
            for (Export export : contribution.getExports()) {
                if (!(export instanceof JavaExport)) continue;
                boolean available = false;
                String packageName = ((JavaExport)export).getPackage();
                for (Artifact artifact : contribution.getArtifacts()) {
                    if (!packageName.equals(artifact.getURI().replace("/", "."))) continue;
                    available = true;
                }
                if (available) continue;
                String message = context.getMonitor().getMessageString(ContributionContentProcessor.class.getName(), "contribution-xml-validation-messages", "ExportedPackageNotFound");
                message = message.replace("{0}", packageName);
                throw new ContributionResolveException(message);
            }
            for (Artifact artifact : contribution.getArtifacts()) {
                Object model = artifact.getModel();
                if (model == null) continue;
                Artifact oldArtifact = context.setArtifact(artifact);
                try {
                    this.artifactProcessor.resolve(model, contributionResolver, context);
                }
                catch (Throwable e) {
                    throw new ContributionResolveException(e);
                }
                finally {
                    context.setArtifact(oldArtifact);
                }
            }
            List<Composite> deployables = contribution.getDeployables();
            Artifact oldArtifact = context.setArtifact(contribution);
            try {
                int n = deployables.size();
                for (int i = 0; i < n; ++i) {
                    Composite deployable = deployables.get(i);
                    Composite resolved = contributionResolver.resolveModel(Composite.class, deployable, context);
                    if (resolved == deployable) continue;
                    deployables.set(i, resolved);
                }
            }
            finally {
                context.setArtifact(oldArtifact);
            }
        }
        finally {
            monitor.popContext();
            context.setContribution(old);
        }
    }

    private void resolveExports(Contribution contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (Export export : contribution.getExports()) {
            if (export instanceof DefaultExport) {
                export.setModelResolver(resolver);
                continue;
            }
            this.extensionProcessor.resolve(export, resolver, context);
        }
    }

    private void resolveImports(Contribution contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, resolver, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL createTempJar(Artifact artifact, Contribution contribution) throws IOException {
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(new File(URI.create(contribution.getLocation()))));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (artifact.getLocation().endsWith(zipEntry.getName())) {
                    int n;
                    String tempName = ("tmp." + artifact.getURI().substring(0, artifact.getURI().length() - 3)).replace('/', '.');
                    File tempFile = File.createTempFile(tempName, ".jar");
                    tempFile.deleteOnExit();
                    fileOutputStream = new FileOutputStream(tempFile);
                    byte[] buf = new byte[2048];
                    while ((n = zipInputStream.read(buf, 0, buf.length)) > -1) {
                        fileOutputStream.write(buf, 0, n);
                    }
                    fileOutputStream.close();
                    zipInputStream.closeEntry();
                    URL uRL = tempFile.toURI().toURL();
                    return uRL;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        throw new IllegalStateException();
    }
}

