/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;

public class DefaultValidationSchemaExtensionPoint
implements ValidationSchemaExtensionPoint {
    private boolean enabled = true;
    private List<String> schemas = new ArrayList<String>();
    private boolean loaded;
    private ExtensionPointRegistry registry;

    public DefaultValidationSchemaExtensionPoint(ExtensionPointRegistry registry, Map<String, String> attributes) {
        String attr;
        this.registry = registry;
        if (attributes != null && (attr = attributes.get("enabled")) != null) {
            this.enabled = Boolean.parseBoolean(attr);
        }
    }

    @Override
    public void addSchema(String uri) {
        this.schemas.add(uri);
    }

    @Override
    public void removeSchema(String uri) {
        this.schemas.remove(uri);
    }

    private synchronized void loadSchemas() {
        Collection schemaDeclarations;
        if (this.loaded || !this.enabled) {
            return;
        }
        try {
            schemaDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations("org.apache.tuscany.sca.contribution.processor.ValidationSchema");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String tuscanyScaXsd = null;
        for (ServiceDeclaration schemaDeclaration : schemaDeclarations) {
            URL url = schemaDeclaration.getResource(schemaDeclaration.getClassName());
            if (url == null) {
                throw new IllegalArgumentException(new FileNotFoundException(schemaDeclaration.getClassName()));
            }
            if (url.toString().contains("tuscany-sca-1.1.xsd")) {
                tuscanyScaXsd = url.toString();
                continue;
            }
            this.schemas.add(url.toString());
        }
        if (tuscanyScaXsd != null) {
            this.schemas.add(0, tuscanyScaXsd);
        }
        this.loaded = true;
    }

    @Override
    public List<String> getSchemas() {
        if (this.enabled) {
            this.loadSchemas();
            return this.schemas;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

