/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;

public abstract class BaseStAXArtifactProcessor {
    private static String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static String SCA11_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    private static final StAXHelper helper = new StAXHelper(null, null, null);

    protected QName getQNameValue(XMLStreamReader reader, String value) {
        return StAXHelper.getValueAsQName((XMLStreamReader)reader, (String)value);
    }

    protected boolean getBoolean(XMLStreamReader reader, String name) {
        Boolean attr = StAXHelper.getAttributeAsBoolean((XMLStreamReader)reader, (String)name);
        if (attr == null) {
            return false;
        }
        return attr;
    }

    protected QName getQName(XMLStreamReader reader, String name) {
        return StAXHelper.getAttributeAsQName((XMLStreamReader)reader, (String)name);
    }

    protected List<QName> getQNames(XMLStreamReader reader, String name) {
        return StAXHelper.getAttributeAsQNames((XMLStreamReader)reader, (String)name);
    }

    protected String getString(XMLStreamReader reader, String name) {
        return StAXHelper.getAttributeAsString((XMLStreamReader)reader, (String)name);
    }

    protected String getURIString(XMLStreamReader reader, String name) {
        return StAXHelper.getAttributeAsURIString((XMLStreamReader)reader, (String)name);
    }

    protected boolean isSet(XMLStreamReader reader, String name) {
        return StAXHelper.isAttributePresent((XMLStreamReader)reader, (String)name);
    }

    protected QName getXSIType(XMLStreamReader reader) {
        return StAXHelper.getXSIType((XMLStreamReader)reader);
    }

    protected boolean nextChildElement(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 2) {
                return false;
            }
            if (event != 1) continue;
            return true;
        }
        return false;
    }

    protected void skipToEndElement(XMLStreamReader reader) throws XMLStreamException {
        StAXHelper.skipToEndElement((XMLStreamReader)reader);
    }

    private String setPrefix(XMLStreamWriter writer, String uri) throws XMLStreamException {
        if (uri == null) {
            return null;
        }
        String prefix = writer.getPrefix(uri);
        if (prefix != null) {
            return null;
        }
        NamespaceContext nsc = writer.getNamespaceContext();
        int i = 1;
        while (nsc.getNamespaceURI(prefix = "ns" + i) != null) {
            ++i;
        }
        writer.setPrefix(prefix, uri);
        return prefix;
    }

    protected void writeStart(XMLStreamWriter writer, String uri, String name, XAttr ... attrs) throws XMLStreamException {
        helper.writeStartElement(writer, "", name, uri);
        this.writeAttributes(writer, attrs);
    }

    protected void writeStart(XMLStreamWriter writer, QName qname, XAttr ... attrs) throws XMLStreamException {
        this.writeStart(writer, qname.getNamespaceURI(), qname.getLocalPart(), attrs);
    }

    protected void writeEnd(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void writeStartDocument(XMLStreamWriter writer, String uri, String name, XAttr ... attrs) throws XMLStreamException {
        writer.writeStartDocument();
        writer.setDefaultNamespace(uri);
        this.writeStart(writer, uri, name, attrs);
    }

    protected void writeStartDocument(XMLStreamWriter writer, QName qname, XAttr ... attrs) throws XMLStreamException {
        this.writeStartDocument(writer, qname.getNamespaceURI(), qname.getLocalPart(), attrs);
    }

    protected void writeEndDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndDocument();
    }

    protected void writeAttributes(XMLStreamWriter writer, XAttr ... attrs) throws XMLStreamException {
        for (XAttr attr : attrs) {
            if (attr == null) continue;
            attr.write(writer);
        }
    }

    protected void readExtendedAttributes(XMLStreamReader reader, Extensible extensible, StAXAttributeProcessor extensionAttributeProcessor, AssemblyFactory extensionFactory, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        QName elementName = reader.getName();
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            Extension attributeExtension;
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || elementName.getNamespaceURI().equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = extensionAttributeProcessor.read(attributeName, reader, context);
            if (attributeValue instanceof Extension) {
                attributeExtension = (Extension)attributeValue;
            } else {
                attributeExtension = extensionFactory.createExtension();
                attributeExtension.setQName(attributeName);
                attributeExtension.setValue(attributeValue);
                attributeExtension.setAttribute(true);
            }
            extensible.getAttributeExtensions().add(attributeExtension);
        }
    }

    protected void writeExtendedAttributes(XMLStreamWriter writer, Extensible extensibleElement, StAXAttributeProcessor extensionAttributeProcessor, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        for (Extension extension : extensibleElement.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            extensionAttributeProcessor.write(extension, writer, context);
        }
    }

    protected void readExtendedElement(XMLStreamReader reader, Extensible extensible, StAXArtifactProcessor extensionProcessor, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Object ext = extensionProcessor.read(reader, context);
        if (extensible != null) {
            extensible.getExtensions().add(ext);
        }
    }

    protected void writeExtendedElements(XMLStreamWriter writer, Extensible extensible, StAXArtifactProcessor extensionProcessor, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        ArrayList otherExtensions = new ArrayList();
        for (Object ext : extensible.getExtensions()) {
            if (ext instanceof Extension) {
                extensionProcessor.write(ext, writer, context);
                continue;
            }
            otherExtensions.add(ext);
        }
        if (otherExtensions.size() > 0) {
            this.writeStart(writer, SCA11_NS, "extensions", new XAttr[0]);
            for (Object extension : otherExtensions) {
                extensionProcessor.write(extension, writer, context);
            }
            this.writeEnd(writer);
        }
    }

    public static class XAttr {
        private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
        private String uri = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
        private String name;
        private Object value;

        public XAttr(String uri, String name, String value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, String value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, List<?> values) {
            this.uri = uri;
            this.name = name;
            this.value = values;
        }

        public XAttr(String name, List<?> values) {
            this(null, name, values);
        }

        public XAttr(String uri, String name, Boolean value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Boolean value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, Integer value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Integer value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, Double value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Double value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, QName value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, QName value) {
            this(null, name, value);
        }

        public String toString() {
            return this.uri == null ? this.name + "=\"" + this.value + "\"" : "{" + this.uri + "}" + this.name + "=\"" + this.value + "\"";
        }

        private String writeQNameValue(XMLStreamWriter writer, QName qname) throws XMLStreamException {
            if (qname != null) {
                String prefix = helper.writeNamespace(writer, qname.getPrefix(), qname.getNamespaceURI());
                if ("".equals(prefix)) {
                    return qname.getLocalPart();
                }
                return prefix + ":" + qname.getLocalPart();
            }
            return null;
        }

        public void write(XMLStreamWriter writer) throws XMLStreamException {
            String str;
            if (this.value instanceof QName) {
                str = this.writeQNameValue(writer, (QName)this.value);
            } else if (this.value instanceof Collection) {
                Collection values = (Collection)this.value;
                if (values.isEmpty()) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (Object v : values) {
                    if (v == null) continue;
                    if (v instanceof XAttr) {
                        ((XAttr)v).write(writer);
                        continue;
                    }
                    if (buffer.length() != 0) {
                        buffer.append(' ');
                    }
                    if (v instanceof QName) {
                        buffer.append(this.writeQNameValue(writer, (QName)v));
                        continue;
                    }
                    buffer.append(String.valueOf(v));
                }
                str = buffer.toString();
            } else {
                if (this.value == null) {
                    return;
                }
                str = String.valueOf(this.value);
            }
            if (str.length() == 0 && this.value instanceof Collection) {
                return;
            }
            helper.writeAttribute(writer, "", this.name, this.uri, str);
        }
    }
}

