/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.impl.ExtensibleImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.impl.ArtifactImpl;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

class ContributionImpl
extends ExtensibleImpl
implements Contribution {
    private String uri;
    private String location;
    private Object model;
    private byte[] contents;
    private List<Export> exports = new ArrayList<Export>();
    private List<Import> imports = new ArrayList<Import>();
    private List<Composite> deployables = new ArrayList<Composite>();
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    private List<Contribution> dependencies = new ArrayList<Contribution>();
    private ModelResolver modelResolver;
    private Set<String> types = new HashSet<String>();
    private List<URL> extractedArchives = new ArrayList<URL>();
    private ClassLoader classLoader;
    private boolean useNestedArchives = true;

    ContributionImpl() {
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public <T> T getModel() {
        return (T)this.model;
    }

    @Override
    public void setModel(Object model) {
        this.model = model;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public void setModelResolver(ModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    @Override
    public List<Contribution> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Export> getExports() {
        return this.exports;
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public List<Composite> getDeployables() {
        return this.deployables;
    }

    @Override
    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Artifact) {
            return this.uri.equals(((Artifact)obj).getURI());
        }
        return false;
    }

    public String toString() {
        return "Contribution : " + this.uri + " \n" + "from: " + this.location;
    }

    @Override
    public Set<String> getTypes() {
        return this.types;
    }

    @Override
    public <T> T getArtifactModel(String uri) {
        for (Artifact a : this.getArtifacts()) {
            if (!a.getURI().equals(uri)) continue;
            return a.getModel();
        }
        throw new IllegalArgumentException("artifact not found: " + uri);
    }

    @Override
    public void mergeMetaData(ContributionMetadata metaData) {
        this.imports.addAll(metaData.getImports());
        this.exports.addAll(metaData.getExports());
        if (metaData.getDeployables().size() > 0) {
            for (Artifact a : this.getArtifacts()) {
                if (!(a.getModel() instanceof Composite)) continue;
                ListIterator<Composite> lit = metaData.getDeployables().listIterator();
                while (lit.hasNext()) {
                    if (!lit.next().getName().equals(((Composite)a.getModel()).getName())) continue;
                    lit.set((Composite)a.getModel());
                }
            }
            this.deployables.addAll(metaData.getDeployables());
        }
    }

    @Override
    public void addComposite(Composite composite) {
        ArtifactImpl a = new ArtifactImpl();
        a.setURI(composite.getURI());
        a.setModel(composite);
        a.setUnresolved(false);
        this.artifacts.add(a);
    }

    @Override
    public List<URL> getExtractedArchives() {
        return this.extractedArchives;
    }

    @Override
    public boolean useNestedArchives() {
        return this.useNestedArchives;
    }

    @Override
    public void setUseNestedArcives(boolean b) {
        this.useNestedArchives = b;
    }
}

