/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.jaxws.ri;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.jaxws.JAXWSBindingProvider;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class JAXWSServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;
    private JAXWSBindingProvider jaxwsBindingProvider;
    private Endpoint wsEndpoint;

    public JAXWSServiceBindingProvider(RuntimeEndpoint endpoint, FactoryExtensionPoint modelFactories, DataBindingExtensionPoint dataBindings, String defaultPort) {
        this.endpoint = endpoint;
        this.wsBinding = (WebServiceBinding)endpoint.getBinding();
        this.jaxwsBindingProvider = new JAXWSBindingProvider(endpoint, modelFactories, dataBindings, defaultPort);
    }

    public void start() {
        this.wsEndpoint = Endpoint.create((String)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)this.jaxwsBindingProvider);
        String targetNamespace = this.wsBinding.getUserSpecifiedWSDLDefinition().getDefinition().getTargetNamespace();
        ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            writer.writeWSDL(this.wsBinding.getUserSpecifiedWSDLDefinition().getDefinition(), (OutputStream)outStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        StreamSource source = new StreamSource(inStream);
        source.setSystemId(targetNamespace);
        metadata.add(source);
        HashMap<String, QName> properties = new HashMap<String, QName>();
        QName portName = new QName(targetNamespace, this.wsBinding.getPort().getName());
        properties.put("javax.xml.ws.wsdl.port", portName);
        QName bindingServiceName = this.wsBinding.getServiceName() == null ? this.wsBinding.getService().getQName() : this.wsBinding.getServiceName();
        QName serviceName = new QName(targetNamespace, bindingServiceName.getLocalPart());
        properties.put("javax.xml.ws.wsdl.service", serviceName);
        this.wsEndpoint.setMetadata(metadata);
        this.wsEndpoint.setProperties(properties);
        this.wsEndpoint.publish(this.wsBinding.getURI());
        this.jaxwsBindingProvider.start();
        this.endpoint.setDeployedURI(this.wsBinding.getURI());
    }

    public void stop() {
        this.jaxwsBindingProvider.stop();
        this.wsEndpoint.stop();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }
}

